/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Avc1Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Mp4aBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4StsdBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final int entryCount;
    private Mp4Box entryBox;

    public Mp4StsdBox(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.STSD;
        this.version = 0;
        this.flags = new byte[3];
        this.entryCount = 1;
        this.entryBox = trackInfo.getType().equals("video") ? new Mp4Avc1Box(trackInfo) : new Mp4Mp4aBox(trackInfo);
    }

    @Override
    public int byteArrayLength() {
        return 16 + this.entryBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(this.entryCount).putBytes(this.entryBox.toByteArray()).getData();
    }
}

