/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;

public class Mp4DrefBox
extends Mp4Box {
    private final int version;
    private final byte[] flags;
    private final int entryCount;
    private final int entrySize;
    private final byte[] entryType;
    private final int entryVersion;
    private final byte[] entryFlag;

    public Mp4DrefBox() {
        this.mp4Type = EMp4Type.DREF;
        this.version = 0;
        this.flags = new byte[3];
        this.entryCount = 1;
        this.entrySize = 12;
        this.entryType = new byte[]{117, 114, 108, 32};
        this.entryVersion = 0;
        this.entryFlag = new byte[]{0, 0, 1};
    }

    @Override
    public int byteArrayLength() {
        return 28;
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putByte(this.version).putBytes(this.flags).putInteger(this.entryCount).putInteger(this.entrySize).putBytes(this.entryType).putByte(this.entryVersion).putBytes(this.entryFlag).getData();
    }
}

