/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.mp4.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.mp4.enums.EMp4Type;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4AvcCBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4Box;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4BtrtBox;
import com.github.xingshuangs.iot.protocol.mp4.model.Mp4TrackInfo;

public class Mp4Avc1Box
extends Mp4Box {
    private final byte[] reserved1;
    private final int dataReferenceIndex;
    private final byte[] preDefined1;
    private final byte[] reserved2;
    private final byte[] preDefined2;
    private final int width;
    private final int height;
    private final int horizResolution;
    private final int vertResolution;
    private final byte[] reserved3;
    private final int frameCount;
    private final byte[] compressNameInfo;
    private final int depth;
    private final byte[] preDefined3;
    private final Mp4AvcCBox avcCBox;
    private final Mp4BtrtBox btrtBox;

    public Mp4Avc1Box(Mp4TrackInfo trackInfo) {
        this.mp4Type = EMp4Type.AVC1;
        this.reserved1 = new byte[6];
        this.dataReferenceIndex = 1;
        this.preDefined1 = new byte[2];
        this.reserved2 = new byte[2];
        this.preDefined2 = new byte[12];
        this.width = trackInfo.getWidth();
        this.height = trackInfo.getHeight();
        this.horizResolution = 0x480000;
        this.vertResolution = 0x480000;
        this.reserved3 = new byte[4];
        this.frameCount = 1;
        this.compressNameInfo = new byte[]{18, 98, 105, 110, 101, 108, 112, 114, 111, 46, 114, 117, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
        this.depth = 24;
        this.preDefined3 = new byte[]{17, 17};
        this.avcCBox = new Mp4AvcCBox(trackInfo);
        this.btrtBox = new Mp4BtrtBox();
    }

    @Override
    public int byteArrayLength() {
        return 86 + this.avcCBox.byteArrayLength() + this.btrtBox.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        int size = this.byteArrayLength();
        return ByteWriteBuff.newInstance(size).putInteger(size).putBytes(this.mp4Type.getByteArray()).putBytes(this.reserved1).putShort(this.dataReferenceIndex).putBytes(this.preDefined1).putBytes(this.reserved2).putBytes(this.preDefined2).putShort(this.width).putShort(this.height).putInteger(this.horizResolution).putInteger(this.vertResolution).putBytes(this.reserved3).putShort(this.frameCount).putBytes(this.compressNameInfo).putShort(this.depth).putBytes(this.preDefined3).putBytes(this.avcCBox.toByteArray()).putBytes(this.btrtBox.toByteArray()).getData();
    }
}

