/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbTcpResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbapHeader;
import com.github.xingshuangs.iot.protocol.modbus.service.ModbusSkeletonAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusTcp
extends ModbusSkeletonAbstract<MbTcpRequest, MbTcpResponse> {
    private static final Logger log = LoggerFactory.getLogger(ModbusTcp.class);

    public ModbusTcp() {
        this(1, "127.0.0.1", 502);
    }

    public ModbusTcp(String ip) {
        this(1, ip, 502);
    }

    public ModbusTcp(String ip, int port) {
        this(1, ip, port);
    }

    public ModbusTcp(int unitId) {
        this(unitId, "127.0.0.1", 502);
    }

    public ModbusTcp(int unitId, String ip) {
        this(unitId, ip, 502);
    }

    public ModbusTcp(int unitId, String ip, int port) {
        super(unitId, ip, port);
        this.tag = "ModbusTcp";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbTcpResponse readFromServer(MbTcpRequest req) {
        byte[] total;
        MbapHeader header;
        int len;
        if (this.comCallback != null) {
            this.comCallback.accept(req.toByteArray());
        }
        Object object = this.objLock;
        synchronized (object) {
            this.write(req.toByteArray());
            byte[] data = new byte[7];
            len = this.read(data);
            if (len < 7) {
                throw new ModbusCommException("MbapHeader is invalid, the read length is inconsistent");
            }
            header = MbapHeader.fromBytes(data);
            total = new byte[data.length + header.getLength() - 1];
            System.arraycopy(data, 0, total, 0, data.length);
            len = this.read(total, data.length, header.getLength() - 1);
        }
        if (len < header.getLength() - 1) {
            throw new ModbusCommException("The length of the data after MbapHeader is inconsistent");
        }
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        MbTcpResponse ack = MbTcpResponse.fromBytes(total);
        this.checkResult(req, ack);
        return ack;
    }

    @Override
    protected void checkResult(MbTcpRequest req, MbTcpResponse ack) {
        if (ack.getPdu() == null) {
            throw new ModbusCommException("PDU is null");
        }
        if (req.getHeader().getTransactionId() != ack.getHeader().getTransactionId()) {
            throw new ModbusCommException("The transaction meta identifier Id is inconsistent");
        }
        if (ack.getPdu().getFunctionCode().getCode() == (req.getPdu().getFunctionCode().getCode() | 0xFFFFFF80)) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The response returns an exception, the exception code:" + response.getErrorCode().getDescription());
        }
        if (ack.getPdu().getFunctionCode().getCode() != req.getPdu().getFunctionCode().getCode()) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The return function code is inconsistent with the send function code. The exception code is: " + response.getErrorCode().getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbPdu readModbusData(int unitId, MbPdu reqPdu) {
        MbTcpRequest request = MbTcpRequest.createDefault();
        request.getHeader().setUnitId(unitId);
        request.setPdu(reqPdu);
        request.selfCheck();
        try {
            MbTcpResponse response = this.readFromServer(request);
            MbPdu mbPdu = response.getPdu();
            return mbPdu;
        }
        finally {
            if (!this.persistence) {
                log.debug("Due to the short connection mode, the communication is triggered to close the connection channel, and the server IP[{}]", (Object)this.socketAddress);
                this.close();
            }
        }
    }
}

