/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.service;

import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbErrorResponse;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbRtuRequest;
import com.github.xingshuangs.iot.protocol.modbus.model.MbRtuResponse;
import com.github.xingshuangs.iot.protocol.modbus.service.ModbusSkeletonAbstract;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ModbusRtuOverTcp
extends ModbusSkeletonAbstract<MbRtuRequest, MbRtuResponse> {
    private static final Logger log = LoggerFactory.getLogger(ModbusRtuOverTcp.class);

    public ModbusRtuOverTcp() {
        this(1, "127.0.0.1", 502);
    }

    public ModbusRtuOverTcp(String ip) {
        this(1, ip, 502);
    }

    public ModbusRtuOverTcp(String ip, int port) {
        this(1, ip, port);
    }

    public ModbusRtuOverTcp(int unitId) {
        this(unitId, "127.0.0.1", 502);
    }

    public ModbusRtuOverTcp(int unitId, String ip) {
        this(unitId, ip, 502);
    }

    public ModbusRtuOverTcp(int unitId, String ip, int port) {
        super(unitId, ip, port);
        this.tag = "ModbusRtu";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbRtuResponse readFromServer(MbRtuRequest req) {
        int len;
        byte[] reqBytes = req.toByteArray();
        if (this.comCallback != null) {
            this.comCallback.accept(reqBytes);
        }
        byte[] data = new byte[1024];
        Object object = this.objLock;
        synchronized (object) {
            this.write(reqBytes);
            len = this.read(data);
        }
        if (len <= 0) {
            throw new ModbusCommException("The length of Modbus data read is incorrect");
        }
        byte[] total = new byte[len];
        System.arraycopy(data, 0, total, 0, len);
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        MbRtuResponse ack = MbRtuResponse.fromBytes(total);
        this.checkResult(req, ack);
        return ack;
    }

    @Override
    protected void checkResult(MbRtuRequest req, MbRtuResponse ack) {
        if (!ack.checkCrc()) {
            throw new ModbusCommException("Response data CRC check failed");
        }
        if (ack.getPdu() == null) {
            throw new ModbusCommException("PDU is null");
        }
        if (ack.getPdu().getFunctionCode().getCode() == (req.getPdu().getFunctionCode().getCode() | 0xFFFFFF80)) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The response returns an exception, the exception code:" + response.getErrorCode().getDescription());
        }
        if (ack.getPdu().getFunctionCode().getCode() != req.getPdu().getFunctionCode().getCode()) {
            MbErrorResponse response = (MbErrorResponse)ack.getPdu();
            throw new ModbusCommException("The return function code is inconsistent with the send function code. The exception code is: " + response.getErrorCode().getDescription());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected MbPdu readModbusData(int unitId, MbPdu reqPdu) {
        MbRtuRequest request = new MbRtuRequest(unitId, reqPdu);
        try {
            MbRtuResponse response = this.readFromServer(request);
            MbPdu mbPdu = response.getPdu();
            return mbPdu;
        }
        finally {
            if (!this.persistence) {
                log.debug("Due to the short connection mode, the communication is triggered to close the connection channel, and the server IP[{}]", (Object)this.socketAddress);
                this.close();
            }
        }
    }
}

