/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.protocol.modbus.model.MbapHeader;

public class MbTcpResponse
implements IObjectByteArray {
    private MbapHeader header;
    private MbPdu pdu;

    @Override
    public int byteArrayLength() {
        return this.header.byteArrayLength() + this.pdu.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putBytes(this.header.toByteArray()).putBytes(this.pdu.toByteArray()).getData();
    }

    public static MbTcpResponse fromBytes(byte[] data) {
        MbTcpResponse response = new MbTcpResponse();
        response.header = MbapHeader.fromBytes(data);
        response.pdu = MbPdu.fromBytes(data, response.header.byteArrayLength());
        return response;
    }

    public static MbTcpResponse fromBytes(MbapHeader header, byte[] pduBytes) {
        MbTcpResponse response = new MbTcpResponse();
        response.header = header;
        response.pdu = MbPdu.fromBytes(pduBytes);
        return response;
    }

    public MbapHeader getHeader() {
        return this.header;
    }

    public MbPdu getPdu() {
        return this.pdu;
    }

    public void setHeader(MbapHeader header) {
        this.header = header;
    }

    public void setPdu(MbPdu pdu) {
        this.pdu = pdu;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbTcpResponse)) {
            return false;
        }
        MbTcpResponse other = (MbTcpResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        MbapHeader this$header = this.getHeader();
        MbapHeader other$header = other.getHeader();
        if (this$header == null ? other$header != null : !((Object)this$header).equals(other$header)) {
            return false;
        }
        MbPdu this$pdu = this.getPdu();
        MbPdu other$pdu = other.getPdu();
        return !(this$pdu == null ? other$pdu != null : !((Object)this$pdu).equals(other$pdu));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbTcpResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        MbapHeader $header = this.getHeader();
        result = result * 59 + ($header == null ? 43 : ((Object)$header).hashCode());
        MbPdu $pdu = this.getPdu();
        result = result * 59 + ($pdu == null ? 43 : ((Object)$pdu).hashCode());
        return result;
    }

    public String toString() {
        return "MbTcpResponse(header=" + this.getHeader() + ", pdu=" + this.getPdu() + ")";
    }
}

