/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.modbus.enums.EMbFunctionCode;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import java.util.Arrays;

public final class MbReadHoldRegisterResponse
extends MbPdu {
    private int count;
    private byte[] register;

    @Override
    public int byteArrayLength() {
        return super.byteArrayLength() + 1 + this.register.length;
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.functionCode.getCode()).putByte(this.count).putBytes(this.register).getData();
    }

    public static MbReadHoldRegisterResponse fromBytes(byte[] data) {
        return MbReadHoldRegisterResponse.fromBytes(data, 0);
    }

    public static MbReadHoldRegisterResponse fromBytes(byte[] data, int offset) {
        ByteReadBuff buff = new ByteReadBuff(data, offset);
        MbReadHoldRegisterResponse res = new MbReadHoldRegisterResponse();
        res.functionCode = EMbFunctionCode.from(buff.getByte());
        res.count = buff.getByteToInt();
        res.register = buff.getBytes(res.count);
        return res;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbReadHoldRegisterResponse)) {
            return false;
        }
        MbReadHoldRegisterResponse other = (MbReadHoldRegisterResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getCount() != other.getCount()) {
            return false;
        }
        return Arrays.equals(this.getRegister(), other.getRegister());
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof MbReadHoldRegisterResponse;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getCount();
        result = result * 59 + Arrays.hashCode(this.getRegister());
        return result;
    }

    public int getCount() {
        return this.count;
    }

    public byte[] getRegister() {
        return this.register;
    }

    public void setCount(int count) {
        this.count = count;
    }

    public void setRegister(byte[] register) {
        this.register = register;
    }

    @Override
    public String toString() {
        return "MbReadHoldRegisterResponse(count=" + this.getCount() + ", register=" + Arrays.toString(this.getRegister()) + ")";
    }
}

