/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.ModbusCommException;
import com.github.xingshuangs.iot.protocol.modbus.model.MbPdu;
import com.github.xingshuangs.iot.utils.LRCUtil;

public class MbAsciiResponse
implements IObjectByteArray {
    private int unitId = 1;
    private MbPdu pdu;
    private byte lrc;

    @Override
    public int byteArrayLength() {
        return 2 + this.pdu.byteArrayLength();
    }

    @Override
    public byte[] toByteArray() {
        return ByteWriteBuff.newInstance(this.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).putByte(this.lrc).getData();
    }

    public void selfCheck() {
        if (this.pdu == null) {
            throw new ModbusCommException("pdu is null");
        }
        byte[] data = ByteWriteBuff.newInstance(1 + this.pdu.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).getData();
        this.lrc = LRCUtil.lrc(data);
    }

    public boolean checkLrc() {
        if (this.pdu == null) {
            throw new ModbusCommException("pdu is null");
        }
        byte[] data = ByteWriteBuff.newInstance(1 + this.pdu.byteArrayLength()).putByte(this.unitId).putBytes(this.pdu.toByteArray()).getData();
        return this.lrc == LRCUtil.lrc(data);
    }

    public static MbAsciiResponse fromBytes(byte[] data) {
        return MbAsciiResponse.fromBytes(data, 0);
    }

    public static MbAsciiResponse fromBytes(byte[] data, int offset) {
        MbAsciiResponse response = new MbAsciiResponse();
        ByteReadBuff buff = ByteReadBuff.newInstance(data, offset);
        response.unitId = buff.getByteToInt(0);
        response.pdu = MbPdu.fromBytes(data, 1);
        response.lrc = buff.getByte(1 + response.pdu.byteArrayLength());
        return response;
    }

    public int getUnitId() {
        return this.unitId;
    }

    public MbPdu getPdu() {
        return this.pdu;
    }

    public byte getLrc() {
        return this.lrc;
    }

    public void setUnitId(int unitId) {
        this.unitId = unitId;
    }

    public void setPdu(MbPdu pdu) {
        this.pdu = pdu;
    }

    public void setLrc(byte lrc) {
        this.lrc = lrc;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MbAsciiResponse)) {
            return false;
        }
        MbAsciiResponse other = (MbAsciiResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getUnitId() != other.getUnitId()) {
            return false;
        }
        if (this.getLrc() != other.getLrc()) {
            return false;
        }
        MbPdu this$pdu = this.getPdu();
        MbPdu other$pdu = other.getPdu();
        return !(this$pdu == null ? other$pdu != null : !((Object)this$pdu).equals(other$pdu));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MbAsciiResponse;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getUnitId();
        result = result * 59 + this.getLrc();
        MbPdu $pdu = this.getPdu();
        result = result * 59 + ($pdu == null ? 43 : ((Object)$pdu).hashCode());
        return result;
    }

    public String toString() {
        return "MbAsciiResponse(unitId=" + this.getUnitId() + ", pdu=" + this.getPdu() + ", lrc=" + this.getLrc() + ")";
    }
}

