/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.modbus.enums;

import java.util.HashMap;
import java.util.Map;

public enum EMbExceptionCode {
    ILLEGAL_FUNCTION(1, "\u975e\u6cd5\u529f\u80fd\u7801"),
    ILLEGAL_DATA_ADDRESS(2, "\u975e\u6cd5\u6570\u636e\u5730\u5740"),
    ILLEGAL_DATA_VALUE(3, "\u975e\u6cd5\u6570\u636e\u503c"),
    SLAVE_DEVICE_FAILURE(4, "\u4ece\u7ad9\u8bbe\u5907\u5931\u8d25"),
    ACKNOWLEDGE(5, "\u786e\u8ba4"),
    SLAVE_DEVICE_BUSY(6, "\u4ece\u5c5e\u8bbe\u5907\u5fd9"),
    MEMORY_PARITY_ERROR(8, "\u5b58\u50a8\u5947\u5076\u6027\u5dee\u9519"),
    GATEWAY_PATH_UNAVAILABLE(10, "\u4e0d\u53ef\u7528\u7f51\u5173\u8def\u5f84"),
    GATEWAY_TARGET_DEVICE_FAILED_TO_RESPOND(11, "\u7f51\u5173\u76ee\u6807\u8bbe\u5907\u54cd\u5e94\u5931\u8d25");

    private static Map<Byte, EMbExceptionCode> map;
    private final byte code;
    private final String description;

    public static EMbExceptionCode from(byte data) {
        if (map == null) {
            map = new HashMap<Byte, EMbExceptionCode>();
            for (EMbExceptionCode item : EMbExceptionCode.values()) {
                map.put(item.code, item);
            }
        }
        return map.get(data);
    }

    private EMbExceptionCode(byte code, String description) {
        this.code = code;
        this.description = description;
    }

    public byte getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }
}

