/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.service;

import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.exceptions.McCommException;
import com.github.xingshuangs.iot.net.client.TcpClientBasic;
import com.github.xingshuangs.iot.protocol.melsec.algorithm.McGroupAlg;
import com.github.xingshuangs.iot.protocol.melsec.algorithm.McGroupItem;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcCommand;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcDeviceCode;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcSeries;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McAckData;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceAddress;
import com.github.xingshuangs.iot.protocol.melsec.model.McDeviceContent;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeaderReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McMessageAck;
import com.github.xingshuangs.iot.protocol.melsec.model.McMessageReq;
import com.github.xingshuangs.iot.protocol.melsec.model.McReadDeviceBatchReqData;
import com.github.xingshuangs.iot.protocol.melsec.model.McReqBuilder;
import com.github.xingshuangs.iot.protocol.melsec.model.McWriteDeviceBatchReqData;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class McNetwork
extends TcpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(McNetwork.class);
    private final Object objLock = new Object();
    private Consumer<byte[]> comCallback;
    private boolean persistence = true;
    protected EMcFrameType frameType = EMcFrameType.FRAME_3E;
    protected McAccessRoute accessRoute = McFrame4E3EAccessRoute.createDefault();
    protected int monitoringTimer = 3000;
    protected EMcSeries series = EMcSeries.Q_L;

    public McNetwork() {
    }

    public McNetwork(String host, int port) {
        super(host, port);
    }

    @Override
    public void connect() {
        try {
            super.connect();
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected McMessageAck readFromServer(McMessageReq req) {
        byte[] total;
        McHeader header;
        int len;
        if (this.comCallback != null) {
            this.comCallback.accept(req.toByteArray());
        }
        Object object = this.objLock;
        synchronized (object) {
            this.write(req.toByteArray());
            int headerLength = this.frameType == EMcFrameType.FRAME_4E ? 13 : 9;
            byte[] data = new byte[headerLength];
            len = this.read(data);
            if (len < headerLength) {
                throw new McCommException(" McHeader is invalid, read length is inconsistent");
            }
            header = McHeader.fromBytes(data, this.frameType);
            total = new byte[headerLength + header.getDataLength()];
            System.arraycopy(data, 0, total, 0, data.length);
            len = this.read(total, data.length, header.getDataLength(), true);
        }
        if (len < header.getDataLength()) {
            throw new McCommException("The length of the data behind the McHeader is inconsistent");
        }
        if (this.comCallback != null) {
            this.comCallback.accept(total);
        }
        McMessageAck ack = McMessageAck.fromBytes(total, this.frameType);
        this.checkResult(req, ack);
        return ack;
    }

    protected void checkResult(McMessageReq req, McMessageAck ack) {
        if (this.frameType == EMcFrameType.FRAME_4E && ack.getHeader().getSubHeader() != EMcFrameType.FRAME_4E.getAckSubHeader()) {
            throw new McCommException("4E frame type, the response sub header is inconsistent with the request sub header, the request sub header\uff1a" + req.getHeader().getSubHeader() + ", the response sub header\uff1a" + ack.getHeader().getEndCode());
        }
        if (this.frameType == EMcFrameType.FRAME_3E && ack.getHeader().getSubHeader() != EMcFrameType.FRAME_3E.getAckSubHeader()) {
            throw new McCommException("4E frame type, the response sub header is inconsistent with the request sub header, the request sub header\uff1a" + req.getHeader().getSubHeader() + ", the response sub header\uff1a" + ack.getHeader().getEndCode());
        }
        if (ack.getHeader().getEndCode() != 0) {
            String errorContent = this.extractError(ack.getHeader().getEndCode());
            String errorStr = String.format("The response returns an exception, an exception code:%d\uff0c%s", ack.getHeader().getEndCode(), errorContent);
            throw new McCommException(errorStr);
        }
    }

    private String extractError(int errorCode) {
        switch (errorCode) {
            case 49232: {
                return "In Communication Data Code Settings, when you set up ASCII code communication, you received data in ASCII code that could not be converted to binary code";
            }
            case 49233: 
            case 49234: 
            case 49235: 
            case 49236: {
                return "The number of write or read points exceeds the allowed range";
            }
            case 49238: {
                return "Write and read requests exceeded the maximum address";
            }
            case 49240: {
                return "The length of the requested data after the ASCII-binary conversion is inconsistent with the number of data in the character part";
            }
            case 49241: {
                return "There is an error in the assignment of instruction or subinstruction";
            }
            case 49243: {
                return "The CPU module cannot write and read the specified software component";
            }
            case 49244: {
                return "There is an error in the request content.(The word software components are written and read in bit units, etc.)";
            }
            case 49245: {
                return "No monitored login";
            }
            case 49247: {
                return "The request to the object CPU module could not be executed";
            }
            case 49248: {
                return "There is an error in the request content.(There is an error in the data assignment of the alignment software component)";
            }
            case 49249: {
                return "The requested data length does not match the number of data in the character section";
            }
            case 49333: {
                return "Specifies data that cannot be processed in the CPU module";
            }
        }
        return "Please consult the Mitsubishi user manual for error resolution, " + errorCode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] readDeviceBatchRaw(EMcCommand command, int subCommand, EMcDeviceCode deviceCode, int headDeviceNumber, int devicePointsCount) {
        try {
            McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
            McDeviceAddress deviceAddress = new McDeviceAddress(deviceCode, headDeviceNumber, devicePointsCount);
            McReadDeviceBatchReqData data = new McReadDeviceBatchReqData();
            data.setSeries(this.series);
            data.setCommand(command);
            data.setSubcommand(subCommand);
            data.setDeviceAddress(deviceAddress);
            McMessageReq req = new McMessageReq(header, data);
            req.selfCheck();
            McMessageAck ack = this.readFromServer(req);
            McAckData ackData = (McAckData)ack.getData();
            byte[] byArray = ackData.getData();
            return byArray;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceBatchRaw(EMcCommand command, int subCommand, EMcDeviceCode deviceCode, int headDeviceNumber, int devicePointsCount, byte[] dataBytes) {
        try {
            McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
            McDeviceContent deviceContent = new McDeviceContent(deviceCode, headDeviceNumber, devicePointsCount, dataBytes);
            McWriteDeviceBatchReqData data = new McWriteDeviceBatchReqData();
            data.setSeries(this.series);
            data.setCommand(command);
            data.setSubcommand(subCommand);
            data.setDeviceContent(deviceContent);
            McMessageReq req = new McMessageReq(header, data);
            req.selfCheck();
            this.readFromServer(req);
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McDeviceContent readDeviceBatchInWord(McDeviceAddress deviceAddress) {
        if (deviceAddress == null) {
            throw new NullPointerException("deviceAddress");
        }
        if (deviceAddress.getDevicePointsCount() < 1) {
            throw new McCommException("1 < device point count");
        }
        if (deviceAddress.getDeviceCode() == EMcDeviceCode.LTS || deviceAddress.getDeviceCode() == EMcDeviceCode.LTC || deviceAddress.getDeviceCode() == EMcDeviceCode.LSTS || deviceAddress.getDeviceCode() == EMcDeviceCode.LSTC || deviceAddress.getDeviceCode() == EMcDeviceCode.LZ) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LSTS\u3001LSTC\u3001LZ");
        }
        try {
            int actualLength = deviceAddress.getDevicePointsCount();
            int maxLength = this.series.getDeviceBatchInWordPointsCount();
            ByteWriteBuff buff = new ByteWriteBuff(deviceAddress.getDevicePointsCount() * 2);
            McGroupAlg.loopExecute(actualLength, maxLength, (off, len) -> {
                McDeviceAddress newAddress = new McDeviceAddress(deviceAddress.getDeviceCode(), deviceAddress.getHeadDeviceNumber() + off, (int)len);
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createReadDeviceBatchInWordReq(this.series, header, newAddress);
                McMessageAck ack = this.readFromServer(req);
                buff.putBytes(((McAckData)ack.getData()).getData());
            });
            McDeviceContent mcDeviceContent = McDeviceContent.createByAddress(deviceAddress, buff.getData());
            return mcDeviceContent;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceBatchInWord(McDeviceContent deviceContent) {
        if (deviceContent == null) {
            throw new NullPointerException("deviceContent");
        }
        if (deviceContent.getDevicePointsCount() < 1) {
            throw new McCommException("1 < device point count");
        }
        if (deviceContent.getDeviceCode() == EMcDeviceCode.LTS || deviceContent.getDeviceCode() == EMcDeviceCode.LTC || deviceContent.getDeviceCode() == EMcDeviceCode.LTN || deviceContent.getDeviceCode() == EMcDeviceCode.LSTS || deviceContent.getDeviceCode() == EMcDeviceCode.LSTC || deviceContent.getDeviceCode() == EMcDeviceCode.LSTN || deviceContent.getDeviceCode() == EMcDeviceCode.LZ) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LTN\u3001LSTS\u3001LSTC\u3001LSTN\u3001LZ");
        }
        try {
            int actualLength = deviceContent.getDevicePointsCount();
            int maxLength = this.series.getDeviceBatchInWordPointsCount();
            ByteReadBuff buff = new ByteReadBuff(deviceContent.getData());
            McGroupAlg.loopExecute(actualLength, maxLength, (off, len) -> {
                McDeviceContent newContent = new McDeviceContent(deviceContent.getDeviceCode(), deviceContent.getHeadDeviceNumber() + off, (int)len, buff.getBytes(off * 2, len * 2));
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createWriteDeviceBatchInWordReq(this.series, header, newContent);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public McDeviceContent readDeviceBatchInBit(McDeviceAddress deviceAddress) {
        if (deviceAddress == null) {
            throw new NullPointerException("deviceAddress");
        }
        if (deviceAddress.getDevicePointsCount() < 1) {
            throw new McCommException("1 < device point count");
        }
        if (!EMcDeviceCode.checkBitType(deviceAddress.getDeviceCode())) {
            throw new McCommException("It can only be bit device code");
        }
        if (deviceAddress.getDeviceCode() == EMcDeviceCode.LTS || deviceAddress.getDeviceCode() == EMcDeviceCode.LTC || deviceAddress.getDeviceCode() == EMcDeviceCode.LSTS || deviceAddress.getDeviceCode() == EMcDeviceCode.LSTC || deviceAddress.getDeviceCode() == EMcDeviceCode.LZ) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LSTS\u3001LSTC\u3001LZ");
        }
        try {
            int maxLength = this.series.getDeviceBatchInBitPointsCount();
            int length = deviceAddress.getDevicePointsCount() % 2 == 0 ? deviceAddress.getDevicePointsCount() / 2 : (deviceAddress.getDevicePointsCount() + 1) / 2;
            ByteWriteBuff buff = new ByteWriteBuff(length);
            McGroupAlg.loopExecute(deviceAddress.getDevicePointsCount(), maxLength, (off, len) -> {
                McDeviceAddress newAddress = new McDeviceAddress(deviceAddress.getDeviceCode(), deviceAddress.getHeadDeviceNumber() + off, (int)len);
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createReadDeviceBatchInBitReq(this.series, header, newAddress);
                McMessageAck ack = this.readFromServer(req);
                buff.putBytes(((McAckData)ack.getData()).getData());
            });
            McDeviceContent mcDeviceContent = McDeviceContent.createByAddress(deviceAddress, buff.getData());
            return mcDeviceContent;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceBatchInBit(McDeviceContent deviceContent) {
        if (deviceContent == null) {
            throw new NullPointerException("deviceContent");
        }
        if (deviceContent.getDevicePointsCount() < 1) {
            throw new McCommException("1 < device point count");
        }
        if (!EMcDeviceCode.checkBitType(deviceContent.getDeviceCode())) {
            throw new McCommException("It can only be bit device code");
        }
        if (deviceContent.getDeviceCode() == EMcDeviceCode.LTS || deviceContent.getDeviceCode() == EMcDeviceCode.LTC || deviceContent.getDeviceCode() == EMcDeviceCode.LTN || deviceContent.getDeviceCode() == EMcDeviceCode.LSTS || deviceContent.getDeviceCode() == EMcDeviceCode.LSTC || deviceContent.getDeviceCode() == EMcDeviceCode.LSTN || deviceContent.getDeviceCode() == EMcDeviceCode.LCN || deviceContent.getDeviceCode() == EMcDeviceCode.LZ) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LTN\u3001LSTS\u3001LSTC\u3001LSTN\u3001LCN\u3001LZ");
        }
        try {
            int actualLength = deviceContent.getDevicePointsCount();
            int maxLength = this.series.getDeviceBatchInBitPointsCount();
            ByteReadBuff buff = new ByteReadBuff(deviceContent.getData());
            McGroupAlg.loopExecute(actualLength, maxLength, (off, len) -> {
                int length = len % 2 == 0 ? len / 2 : (len + 1) / 2;
                McDeviceContent newContent = new McDeviceContent(deviceContent.getDeviceCode(), deviceContent.getHeadDeviceNumber() + off, (int)len, buff.getBytes(off / 2, length));
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createWriteDeviceBatchInBitReq(this.series, header, newContent);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<McDeviceContent> readDeviceRandomInWord(List<McDeviceAddress> wordAddresses, List<McDeviceAddress> dwordAddresses) {
        if (wordAddresses == null || dwordAddresses == null) {
            throw new NullPointerException("wordAddresses or dwordAddresses");
        }
        if (wordAddresses.isEmpty() && dwordAddresses.isEmpty()) {
            throw new IllegalArgumentException("wordAddresses and dwordAddresses is empty");
        }
        boolean wordAllMatch = this.checkDeviceRandomCode(wordAddresses);
        boolean dwordAllMatch = this.checkDeviceRandomCode(dwordAddresses);
        if (!wordAllMatch || !dwordAllMatch) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LSTS\u3001LSTC\u3001LCS\u3001LCC");
        }
        try {
            ArrayList<McDeviceContent> result = new ArrayList<McDeviceContent>();
            int maxLength = this.series.getDeviceRandomReadInWordPointsCount();
            BiPredicate<McGroupItem, McGroupItem> biPredicate = (i1, i2) -> i1.getLen() + i2.getLen() >= maxLength;
            McGroupItem wordItem = new McGroupItem(wordAddresses.size());
            McGroupItem dwordItem = new McGroupItem(dwordAddresses.size());
            McGroupAlg.biLoopExecute(wordItem, dwordItem, biPredicate, (i1, i2) -> {
                List<McDeviceAddress> newWords = wordAddresses.subList(i1.getOff(), i1.getOff() + i1.getLen());
                List<McDeviceAddress> newDWords = dwordAddresses.subList(i2.getOff(), i2.getOff() + i2.getLen());
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createReadDeviceRandomInWordReq(this.series, header, newWords, newDWords);
                McMessageAck ack = this.readFromServer(req);
                ByteReadBuff buff = new ByteReadBuff(((McAckData)ack.getData()).getData());
                for (McDeviceAddress word : newWords) {
                    result.add(McDeviceContent.createByAddress(word, buff.getBytes(2)));
                }
                for (McDeviceAddress dword : newDWords) {
                    result.add(McDeviceContent.createByAddress(dword, buff.getBytes(4)));
                }
            });
            ArrayList<McDeviceContent> arrayList = result;
            return arrayList;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    private boolean checkDeviceRandomCode(List<? extends McDeviceAddress> addresses) {
        return addresses.stream().allMatch(x -> x.getDeviceCode() != EMcDeviceCode.LTS && x.getDeviceCode() != EMcDeviceCode.LTC && x.getDeviceCode() != EMcDeviceCode.LSTS && x.getDeviceCode() != EMcDeviceCode.LSTC && x.getDeviceCode() != EMcDeviceCode.LCS && x.getDeviceCode() != EMcDeviceCode.LCC);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceRandomInWord(List<McDeviceContent> wordContents, List<McDeviceContent> dwordContents) {
        if (wordContents == null || dwordContents == null) {
            throw new NullPointerException("wordContents or dwordContents");
        }
        if (wordContents.isEmpty() && dwordContents.isEmpty()) {
            throw new IllegalArgumentException("wordContents and dwordContents is empty");
        }
        boolean wordAllMatch = this.checkDeviceRandomCode(wordContents);
        boolean dwordAllMatch = this.checkDeviceRandomCode(dwordContents);
        if (!wordAllMatch || !dwordAllMatch) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LSTS\u3001LSTC\u3001LCS\u3001LCC");
        }
        try {
            int maxLength = this.series.getDeviceRandomWriteInWordPointsCount();
            BiPredicate<McGroupItem, McGroupItem> biPredicate = (i1, i2) -> i1.getLen() * 12 + i2.getLen() * 14 >= maxLength;
            McGroupItem wordItem = new McGroupItem(wordContents.size());
            McGroupItem dwordItem = new McGroupItem(dwordContents.size());
            McGroupAlg.biLoopExecute(wordItem, dwordItem, biPredicate, (i1, i2) -> {
                List<McDeviceContent> newWord = wordContents.subList(i1.getOff(), i1.getOff() + i1.getLen());
                List<McDeviceContent> newDWord = dwordContents.subList(i2.getOff(), i2.getOff() + i2.getLen());
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createWriteDeviceRandomInWordReq(this.series, header, newWord, newDWord);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceRandomInBit(List<McDeviceContent> bitAddresses) {
        if (bitAddresses == null || bitAddresses.isEmpty()) {
            throw new IllegalArgumentException("bitAddresses is null or empty");
        }
        boolean allMatch = bitAddresses.stream().allMatch(x -> EMcDeviceCode.checkBitType(x.getDeviceCode()));
        if (!allMatch) {
            throw new McCommException("It can only be bit device code");
        }
        try {
            int maxLength = this.series.getDeviceRandomWriteInBitPointsCount();
            McGroupAlg.loopExecute(bitAddresses.size(), maxLength, (off, len) -> {
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createWriteDeviceRandomInBitReq(this.series, header, bitAddresses.subList((int)off, off + len));
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<McDeviceContent> readDeviceBatchMultiBlocks(List<McDeviceAddress> wordAddresses, List<McDeviceAddress> bitAddresses) {
        this.checkDeviceBatchMultiBlocksCondition(wordAddresses, bitAddresses);
        try {
            ArrayList<McDeviceContent> result = new ArrayList<McDeviceContent>();
            int maxLength = this.series.getDeviceBlocksBlocksCount();
            BiPredicate<McGroupItem, McGroupItem> biPredicate = (i1, i2) -> i1.getLen() + i2.getLen() >= maxLength;
            McGroupItem wordItem = new McGroupItem(wordAddresses.size());
            McGroupItem bitItem = new McGroupItem(bitAddresses.size());
            McGroupAlg.biLoopExecute(wordItem, bitItem, biPredicate, (i1, i2) -> {
                List<McDeviceAddress> newWords = wordAddresses.subList(i1.getOff(), i1.getOff() + i1.getLen());
                List<McDeviceAddress> newBits = bitAddresses.subList(i2.getOff(), i2.getOff() + i2.getLen());
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createReadDeviceBatchMultiBlocksReq(this.series, header, newWords, newBits);
                McMessageAck ack = this.readFromServer(req);
                ByteReadBuff buff = new ByteReadBuff(((McAckData)ack.getData()).getData());
                for (McDeviceAddress word : newWords) {
                    result.add(McDeviceContent.createByAddress(word, buff.getBytes(2 * word.getDevicePointsCount())));
                }
                for (McDeviceAddress bit : newBits) {
                    result.add(McDeviceContent.createByAddress(bit, buff.getBytes(2 * bit.getDevicePointsCount())));
                }
            });
            ArrayList<McDeviceContent> arrayList = result;
            return arrayList;
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    private void checkDeviceBatchMultiBlocksCondition(List<? extends McDeviceAddress> words, List<? extends McDeviceAddress> bits) {
        if (words == null || bits == null) {
            throw new NullPointerException("wordAddresses or bitAddresses");
        }
        if (words.isEmpty() && bits.isEmpty()) {
            throw new IllegalArgumentException("the number of wordAddresses and bitAddresses is empty");
        }
        if (this.frameType == EMcFrameType.FRAME_3E) {
            throw new McCommException("3E Currently does not support batch block read and write");
        }
        boolean b1 = words.stream().allMatch(x -> EMcDeviceCode.checkWordType(x.getDeviceCode()));
        if (!b1) {
            throw new McCommException("word device code error");
        }
        boolean b2 = bits.stream().allMatch(x -> EMcDeviceCode.checkBitType(x.getDeviceCode()));
        if (!b2) {
            throw new McCommException("bit device code error");
        }
        boolean wordAllMatch = this.checkDeviceBatchMultiBlocksCode(words);
        boolean bitAllMatch = this.checkDeviceBatchMultiBlocksCode(bits);
        if (!wordAllMatch || !bitAllMatch) {
            throw new McCommException("restricted access LTS\u3001LTC\u3001LTN\u3001LSTS\u3001LSTC\u3001LSTN\u3001LCS\u3001LCC\u3001LCN\u3001LZ");
        }
    }

    private boolean checkDeviceBatchMultiBlocksCode(List<? extends McDeviceAddress> addresses) {
        return addresses.stream().allMatch(x -> x.getDeviceCode() != EMcDeviceCode.LTS && x.getDeviceCode() != EMcDeviceCode.LTC && x.getDeviceCode() != EMcDeviceCode.LTN && x.getDeviceCode() != EMcDeviceCode.LSTS && x.getDeviceCode() != EMcDeviceCode.LSTC && x.getDeviceCode() != EMcDeviceCode.LSTN && x.getDeviceCode() != EMcDeviceCode.LCS && x.getDeviceCode() != EMcDeviceCode.LCC && x.getDeviceCode() != EMcDeviceCode.LCN && x.getDeviceCode() != EMcDeviceCode.LZ);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeDeviceBatchMultiBlocks(List<McDeviceContent> wordContents, List<McDeviceContent> bitContents) {
        this.checkDeviceBatchMultiBlocksCondition(wordContents, bitContents);
        try {
            BiPredicate<McGroupItem, McGroupItem> biPredicate = (i1, i2) -> {
                List newWord = wordContents.subList(i1.getOff(), i1.getOff() + i1.getLen());
                List newBit = bitContents.subList(i2.getOff(), i2.getOff() + i2.getLen());
                int blockNum = newWord.size() + newBit.size();
                int count = blockNum * this.series.getDeviceBlocksWritePointsSize() + (newWord.stream().mapToInt(McDeviceAddress::getDevicePointsCount).sum() + newBit.stream().mapToInt(McDeviceAddress::getDevicePointsCount).sum());
                return blockNum >= this.series.getDeviceBlocksBlocksCount() || count >= this.series.getDeviceBlocksWritePointsCount();
            };
            McGroupItem wordItem = new McGroupItem(wordContents.size());
            McGroupItem bitItem = new McGroupItem(bitContents.size());
            McGroupAlg.biLoopExecute(wordItem, bitItem, biPredicate, (i1, i2) -> {
                List<McDeviceContent> newWords = wordContents.subList(i1.getOff(), i1.getOff() + i1.getLen());
                List<McDeviceContent> newBits = bitContents.subList(i2.getOff(), i2.getOff() + i2.getLen());
                McHeaderReq header = new McHeaderReq(this.frameType.getReqSubHeader(), this.accessRoute, this.monitoringTimer);
                McMessageReq req = McReqBuilder.createWriteDeviceBatchMultiBlocksReq(this.series, header, newWords, newBits);
                this.readFromServer(req);
            });
        }
        finally {
            if (!this.persistence) {
                this.close();
            }
        }
    }

    public List<Boolean> getBooleansBy(byte[] bytes) {
        ArrayList<Boolean> res = new ArrayList<Boolean>();
        for (byte aByte : bytes) {
            res.add((aByte & 0xFFFFFFF0) == 16);
            res.add((aByte & 0xF) == 1);
        }
        return res;
    }

    public byte[] getBytesBy(List<Boolean> booleans) {
        int len = booleans.size() % 2 == 0 ? booleans.size() / 2 : (booleans.size() + 1) / 2;
        byte[] result = new byte[len];
        for (int i = 0; i < len; ++i) {
            if (Boolean.TRUE.equals(booleans.get(i * 2))) {
                int n = i;
                result[n] = (byte)(result[n] | 0x10);
            }
            if (i * 2 + 1 >= booleans.size() || !Boolean.TRUE.equals(booleans.get(i * 2 + 1))) continue;
            int n = i;
            result[n] = (byte)(result[n] | 1);
        }
        return result;
    }

    public Object getObjLock() {
        return this.objLock;
    }

    public Consumer<byte[]> getComCallback() {
        return this.comCallback;
    }

    public boolean isPersistence() {
        return this.persistence;
    }

    public EMcFrameType getFrameType() {
        return this.frameType;
    }

    public McAccessRoute getAccessRoute() {
        return this.accessRoute;
    }

    public int getMonitoringTimer() {
        return this.monitoringTimer;
    }

    public EMcSeries getSeries() {
        return this.series;
    }

    public void setComCallback(Consumer<byte[]> comCallback) {
        this.comCallback = comCallback;
    }

    public void setPersistence(boolean persistence) {
        this.persistence = persistence;
    }

    public void setFrameType(EMcFrameType frameType) {
        this.frameType = frameType;
    }

    public void setAccessRoute(McAccessRoute accessRoute) {
        this.accessRoute = accessRoute;
    }

    public void setMonitoringTimer(int monitoringTimer) {
        this.monitoringTimer = monitoringTimer;
    }

    public void setSeries(EMcSeries series) {
        this.series = series;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McNetwork)) {
            return false;
        }
        McNetwork other = (McNetwork)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isPersistence() != other.isPersistence()) {
            return false;
        }
        if (this.getMonitoringTimer() != other.getMonitoringTimer()) {
            return false;
        }
        Object this$objLock = this.getObjLock();
        Object other$objLock = other.getObjLock();
        if (this$objLock == null ? other$objLock != null : !this$objLock.equals(other$objLock)) {
            return false;
        }
        Consumer<byte[]> this$comCallback = this.getComCallback();
        Consumer<byte[]> other$comCallback = other.getComCallback();
        if (this$comCallback == null ? other$comCallback != null : !this$comCallback.equals(other$comCallback)) {
            return false;
        }
        EMcFrameType this$frameType = this.getFrameType();
        EMcFrameType other$frameType = other.getFrameType();
        if (this$frameType == null ? other$frameType != null : !((Object)((Object)this$frameType)).equals((Object)other$frameType)) {
            return false;
        }
        McAccessRoute this$accessRoute = this.getAccessRoute();
        McAccessRoute other$accessRoute = other.getAccessRoute();
        if (this$accessRoute == null ? other$accessRoute != null : !this$accessRoute.equals(other$accessRoute)) {
            return false;
        }
        EMcSeries this$series = this.getSeries();
        EMcSeries other$series = other.getSeries();
        return !(this$series == null ? other$series != null : !((Object)((Object)this$series)).equals((Object)other$series));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McNetwork;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isPersistence() ? 79 : 97);
        result = result * 59 + this.getMonitoringTimer();
        Object $objLock = this.getObjLock();
        result = result * 59 + ($objLock == null ? 43 : $objLock.hashCode());
        Consumer<byte[]> $comCallback = this.getComCallback();
        result = result * 59 + ($comCallback == null ? 43 : $comCallback.hashCode());
        EMcFrameType $frameType = this.getFrameType();
        result = result * 59 + ($frameType == null ? 43 : ((Object)((Object)$frameType)).hashCode());
        McAccessRoute $accessRoute = this.getAccessRoute();
        result = result * 59 + ($accessRoute == null ? 43 : $accessRoute.hashCode());
        EMcSeries $series = this.getSeries();
        result = result * 59 + ($series == null ? 43 : ((Object)((Object)$series)).hashCode());
        return result;
    }

    public String toString() {
        return "McNetwork(objLock=" + this.getObjLock() + ", comCallback=" + this.getComCallback() + ", persistence=" + this.isPersistence() + ", frameType=" + (Object)((Object)this.getFrameType()) + ", accessRoute=" + this.getAccessRoute() + ", monitoringTimer=" + this.getMonitoringTimer() + ", series=" + (Object)((Object)this.getSeries()) + ")";
    }
}

