/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McHeader;
import java.util.concurrent.atomic.AtomicInteger;

public class McHeaderReq
extends McHeader {
    private static final AtomicInteger index = new AtomicInteger();
    private int monitoringTimer;

    public McHeaderReq() {
    }

    public McHeaderReq(int subHeader, McAccessRoute accessRoute, int timer) {
        this.subHeader = subHeader;
        this.accessRoute = accessRoute;
        this.monitoringTimer = timer / 250;
        this.serialNumber = McHeaderReq.getNewNumber();
    }

    public static int getNewNumber() {
        int res = index.getAndIncrement();
        if (res >= 65536) {
            index.set(0);
            res = 0;
        }
        return res;
    }

    @Override
    public int byteArrayLength() {
        return (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2 + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2 + 2;
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true).putShort(this.subHeader);
        if (this.frameType == EMcFrameType.FRAME_4E) {
            buff.putShort(this.serialNumber);
            buff.putShort(this.fixedNumber);
        }
        return buff.putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).putShort(this.monitoringTimer).getData();
    }

    public int getMonitoringTimer() {
        return this.monitoringTimer;
    }

    public void setMonitoringTimer(int monitoringTimer) {
        this.monitoringTimer = monitoringTimer;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeaderReq)) {
            return false;
        }
        McHeaderReq other = (McHeaderReq)o;
        if (!other.canEqual(this)) {
            return false;
        }
        return this.getMonitoringTimer() == other.getMonitoringTimer();
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof McHeaderReq;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getMonitoringTimer();
        return result;
    }

    @Override
    public String toString() {
        return "McHeaderReq(monitoringTimer=" + this.getMonitoringTimer() + ")";
    }
}

