/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.protocol.melsec.model;

import com.github.xingshuangs.iot.common.IObjectByteArray;
import com.github.xingshuangs.iot.common.buff.ByteReadBuff;
import com.github.xingshuangs.iot.common.buff.ByteWriteBuff;
import com.github.xingshuangs.iot.protocol.melsec.enums.EMcFrameType;
import com.github.xingshuangs.iot.protocol.melsec.model.McAccessRoute;
import com.github.xingshuangs.iot.protocol.melsec.model.McFrame4E3EAccessRoute;

public class McHeader
implements IObjectByteArray {
    protected EMcFrameType frameType = EMcFrameType.FRAME_3E;
    protected int subHeader = 0;
    protected int serialNumber = 0;
    protected int fixedNumber = 0;
    protected McAccessRoute accessRoute;
    protected int dataLength = 0;

    @Override
    public int byteArrayLength() {
        return (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2;
    }

    @Override
    public byte[] toByteArray() {
        int length = (this.frameType == EMcFrameType.FRAME_4E ? 6 : 2) + this.accessRoute.byteArrayLength() + 2;
        ByteWriteBuff buff = ByteWriteBuff.newInstance(length, true).putShort(this.subHeader);
        if (this.frameType == EMcFrameType.FRAME_4E) {
            buff.putShort(this.serialNumber);
            buff.putShort(this.fixedNumber);
        }
        return buff.putBytes(this.accessRoute.toByteArray()).putShort(this.dataLength).getData();
    }

    public static McHeader fromBytes(byte[] data, EMcFrameType frameType) {
        return McHeader.fromBytes(data, 0, frameType);
    }

    public static McHeader fromBytes(byte[] data, int offset, EMcFrameType frameType) {
        ByteReadBuff buff = new ByteReadBuff(data, offset, true);
        McHeader res = new McHeader();
        res.frameType = frameType;
        res.subHeader = buff.getUInt16();
        if (frameType == EMcFrameType.FRAME_4E) {
            res.serialNumber = buff.getUInt16();
            res.fixedNumber = buff.getUInt16();
        }
        res.accessRoute = McFrame4E3EAccessRoute.fromBytes(buff.getBytes(5));
        res.dataLength = buff.getUInt16();
        return res;
    }

    public EMcFrameType getFrameType() {
        return this.frameType;
    }

    public int getSubHeader() {
        return this.subHeader;
    }

    public int getSerialNumber() {
        return this.serialNumber;
    }

    public int getFixedNumber() {
        return this.fixedNumber;
    }

    public McAccessRoute getAccessRoute() {
        return this.accessRoute;
    }

    public int getDataLength() {
        return this.dataLength;
    }

    public void setFrameType(EMcFrameType frameType) {
        this.frameType = frameType;
    }

    public void setSubHeader(int subHeader) {
        this.subHeader = subHeader;
    }

    public void setSerialNumber(int serialNumber) {
        this.serialNumber = serialNumber;
    }

    public void setFixedNumber(int fixedNumber) {
        this.fixedNumber = fixedNumber;
    }

    public void setAccessRoute(McAccessRoute accessRoute) {
        this.accessRoute = accessRoute;
    }

    public void setDataLength(int dataLength) {
        this.dataLength = dataLength;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof McHeader)) {
            return false;
        }
        McHeader other = (McHeader)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getSubHeader() != other.getSubHeader()) {
            return false;
        }
        if (this.getSerialNumber() != other.getSerialNumber()) {
            return false;
        }
        if (this.getFixedNumber() != other.getFixedNumber()) {
            return false;
        }
        if (this.getDataLength() != other.getDataLength()) {
            return false;
        }
        EMcFrameType this$frameType = this.getFrameType();
        EMcFrameType other$frameType = other.getFrameType();
        if (this$frameType == null ? other$frameType != null : !((Object)((Object)this$frameType)).equals((Object)other$frameType)) {
            return false;
        }
        McAccessRoute this$accessRoute = this.getAccessRoute();
        McAccessRoute other$accessRoute = other.getAccessRoute();
        return !(this$accessRoute == null ? other$accessRoute != null : !this$accessRoute.equals(other$accessRoute));
    }

    protected boolean canEqual(Object other) {
        return other instanceof McHeader;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getSubHeader();
        result = result * 59 + this.getSerialNumber();
        result = result * 59 + this.getFixedNumber();
        result = result * 59 + this.getDataLength();
        EMcFrameType $frameType = this.getFrameType();
        result = result * 59 + ($frameType == null ? 43 : ((Object)((Object)$frameType)).hashCode());
        McAccessRoute $accessRoute = this.getAccessRoute();
        result = result * 59 + ($accessRoute == null ? 43 : $accessRoute.hashCode());
        return result;
    }

    public String toString() {
        return "McHeader(frameType=" + (Object)((Object)this.getFrameType()) + ", subHeader=" + this.getSubHeader() + ", serialNumber=" + this.getSerialNumber() + ", fixedNumber=" + this.getFixedNumber() + ", accessRoute=" + this.getAccessRoute() + ", dataLength=" + this.getDataLength() + ")";
    }
}

