/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net.client;

import com.github.xingshuangs.iot.net.client.UdpClientBasic;
import java.util.concurrent.CompletableFuture;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UdpClientSample
extends UdpClientBasic {
    private static final Logger log = LoggerFactory.getLogger(UdpClientSample.class);
    private boolean terminal = false;
    private Consumer<byte[]> commCallback;

    public void setCommCallback(Consumer<byte[]> commCallback) {
        this.commCallback = commCallback;
    }

    public UdpClientSample() {
    }

    public UdpClientSample(String ip, int port) {
        super(ip, port);
    }

    @Override
    public void close() {
        this.terminal = true;
        super.close();
    }

    private void waitForReceiveData() {
        log.debug("Open the receiving thread, remote IP:{}, port number :{}", (Object)this.serverAddress.getAddress().getHostAddress(), (Object)this.serverAddress.getPort());
        while (!this.terminal) {
            try {
                byte[] data = this.read();
                log.debug("data length\uff1a{}", (Object)data.length);
                if (this.commCallback == null) continue;
                this.commCallback.accept(data);
            }
            catch (Exception e) {
                log.error(e.getMessage());
            }
        }
    }

    public void triggerReceive() {
        CompletableFuture.runAsync(this::waitForReceiveData);
    }
}

