/*
 * Decompiled with CFR 0.152.
 */
package com.github.xingshuangs.iot.net;

import com.github.xingshuangs.iot.net.IAckListener;
import java.time.LocalDateTime;
import java.util.concurrent.CompletableFuture;

public class AckCallback<T> {
    protected T ackData = null;
    protected final IAckListener<T> listener;
    protected boolean completed = false;
    protected String errorMessage;
    protected final long timeoutMs;
    protected final Object lock = new Object();
    protected final LocalDateTime createTime = LocalDateTime.now();

    public AckCallback() {
        this(null);
    }

    public AckCallback(IAckListener<T> listener) {
        this.timeoutMs = 10000L;
        this.listener = listener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseOk(T ackPackage) {
        this.ackData = ackPackage;
        this.completed = true;
        this.errorMessage = "";
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        if (this.listener != null) {
            CompletableFuture.runAsync(() -> this.listener.ok(ackPackage));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void responseFail(String message) {
        this.ackData = null;
        this.completed = true;
        this.errorMessage = message;
        Object object = this.lock;
        synchronized (object) {
            this.lock.notifyAll();
        }
        if (this.listener != null) {
            CompletableFuture.runAsync(() -> this.listener.fail(message));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitData() {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(this.timeoutMs);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitData(long timeout) {
        try {
            Object object = this.lock;
            synchronized (object) {
                this.lock.wait(timeout);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public T getAckData() {
        return this.ackData;
    }

    public IAckListener<T> getListener() {
        return this.listener;
    }

    public boolean isCompleted() {
        return this.completed;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public long getTimeoutMs() {
        return this.timeoutMs;
    }

    public Object getLock() {
        return this.lock;
    }

    public LocalDateTime getCreateTime() {
        return this.createTime;
    }
}

