/*
 * Decompiled with CFR 0.152.
 */
package com.github.xiaoymin.knife4j.aggre.core;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.io.IoUtil;
import cn.hutool.core.util.StrUtil;
import cn.hutool.json.JSONObject;
import com.github.xiaoymin.knife4j.aggre.core.RouteCache;
import com.github.xiaoymin.knife4j.aggre.core.RouteExecutor;
import com.github.xiaoymin.knife4j.aggre.core.RouteRepository;
import com.github.xiaoymin.knife4j.aggre.core.RouteRequestContext;
import com.github.xiaoymin.knife4j.aggre.core.RouteResponse;
import com.github.xiaoymin.knife4j.aggre.core.common.ExecutorEnum;
import com.github.xiaoymin.knife4j.aggre.core.common.RouteUtils;
import com.github.xiaoymin.knife4j.aggre.core.executor.ApacheClientExecutor;
import com.github.xiaoymin.knife4j.aggre.core.executor.OkHttpClientExecutor;
import com.github.xiaoymin.knife4j.aggre.core.pojo.BasicAuth;
import com.github.xiaoymin.knife4j.aggre.core.pojo.HeaderWrapper;
import com.github.xiaoymin.knife4j.aggre.core.pojo.SwaggerRoute;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URI;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.ServletException;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.Part;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RouteDispatcher {
    public static final String ROUTE_PROXY_HEADER_NAME = "knfie4j-gateway-request";
    public static final String ROUTE_PROXY_HEADER_BASIC_NAME = "knife4j-gateway-basic-request";
    public static final String OPENAPI_GROUP_ENDPOINT = "/swagger-resources";
    public static final String OPENAPI_GROUP_INSTANCE_ENDPOINT = "/swagger-instance";
    public static final String ROUTE_BASE_PATH = "/";
    Logger logger = LoggerFactory.getLogger(RouteDispatcher.class);
    private String rootPath;
    private RouteRepository routeRepository;
    private RouteExecutor routeExecutor;
    private RouteCache<String, SwaggerRoute> routeCache;
    private Set<String> ignoreHeaders = new HashSet<String>();

    public RouteDispatcher(RouteRepository routeRepository, RouteCache<String, SwaggerRoute> routeRouteCache, ExecutorEnum executorEnum, String rootPath) {
        this.routeRepository = routeRepository;
        this.routeCache = routeRouteCache;
        this.rootPath = rootPath;
        this.initExecutor(executorEnum);
        this.ignoreHeaders.addAll(Arrays.asList("host", "content-length", ROUTE_PROXY_HEADER_NAME, ROUTE_PROXY_HEADER_BASIC_NAME, "Request-Origion"));
    }

    private void initExecutor(ExecutorEnum executorEnum) {
        if (executorEnum == null) {
            throw new IllegalArgumentException("ExecutorEnum can not be empty");
        }
        switch (executorEnum) {
            case APACHE: {
                this.routeExecutor = new ApacheClientExecutor();
                break;
            }
            case OKHTTP: {
                this.routeExecutor = new OkHttpClientExecutor();
                break;
            }
            default: {
                throw new UnsupportedOperationException("UnSupported ExecutorType:" + executorEnum.name());
            }
        }
    }

    public boolean checkRoute(String header) {
        SwaggerRoute swaggerRoute;
        if (StrUtil.isNotBlank((CharSequence)header) && (swaggerRoute = this.routeRepository.getRoute(header)) != null) {
            return StrUtil.isNotBlank((CharSequence)swaggerRoute.getUri());
        }
        return false;
    }

    public void execute(HttpServletRequest request, HttpServletResponse response) {
        try {
            RouteRequestContext routeContext = new RouteRequestContext();
            this.buildContext(routeContext, request);
            RouteResponse routeResponse = this.routeExecutor.executor(routeContext);
            this.writeResponseStatus(routeResponse, response);
            this.writeResponseHeader(routeResponse, response);
            this.writeBody(routeResponse, response);
        }
        catch (Exception e) {
            this.logger.error("has Error:{}", (Object)e.getMessage());
            this.logger.error(e.getMessage(), (Throwable)e);
            this.writeDefault(request, response, e.getMessage());
        }
    }

    protected void writeDefault(HttpServletRequest request, HttpServletResponse response, String errMsg) {
        response.setContentType("application/json");
        response.setCharacterEncoding("UTF-8");
        try {
            PrintWriter printWriter = response.getWriter();
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("message", errMsg);
            map.put("code", "500");
            map.put("path", request.getRequestURI());
            new JSONObject(map).write((Writer)printWriter);
            printWriter.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    protected void writeResponseStatus(RouteResponse routeResponse, HttpServletResponse response) {
        if (routeResponse != null) {
            response.setStatus(routeResponse.getStatusCode());
        }
    }

    protected void writeResponseHeader(RouteResponse routeResponse, HttpServletResponse response) {
        if (routeResponse != null) {
            if (CollectionUtil.isNotEmpty(routeResponse.getHeaders())) {
                for (HeaderWrapper header : routeResponse.getHeaders()) {
                    if (StrUtil.equalsIgnoreCase((CharSequence)header.getName(), (CharSequence)"Transfer-Encoding")) continue;
                    response.addHeader(header.getName(), header.getValue());
                }
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("\u54cd\u5e94\u7c7b\u578b:{},\u54cd\u5e94\u7f16\u7801:{}", (Object)routeResponse.getContentType(), (Object)routeResponse.getCharsetEncoding());
            }
            response.setContentType(routeResponse.getContentType());
            if (routeResponse.getContentLength() > 0L) {
                response.setContentLengthLong(routeResponse.getContentLength().longValue());
            }
            response.setCharacterEncoding(routeResponse.getCharsetEncoding().displayName());
        }
    }

    protected void writeBody(RouteResponse routeResponse, HttpServletResponse response) throws IOException {
        if (routeResponse != null) {
            if (routeResponse.success()) {
                InputStream inputStream = routeResponse.getBody();
                if (inputStream != null) {
                    int read = -1;
                    byte[] bytes = new byte[0x100000];
                    ServletOutputStream outputStream = response.getOutputStream();
                    while ((read = inputStream.read(bytes)) != -1) {
                        outputStream.write(bytes, 0, read);
                    }
                    IoUtil.close((Closeable)inputStream);
                    IoUtil.close((Closeable)outputStream);
                }
            } else {
                String text = routeResponse.text();
                if (StrUtil.isNotBlank((CharSequence)text)) {
                    PrintWriter printWriter = response.getWriter();
                    printWriter.write(text);
                    printWriter.close();
                }
            }
        }
    }

    protected void buildContext(RouteRequestContext routeRequestContext, HttpServletRequest request) throws IOException {
        SwaggerRoute swaggerRoute;
        String uri;
        BasicAuth basicAuth;
        String basicHeader = request.getHeader(ROUTE_PROXY_HEADER_BASIC_NAME);
        if (StrUtil.isNotBlank((CharSequence)basicHeader) && (basicAuth = this.routeRepository.getAuth(basicHeader)) != null) {
            routeRequestContext.addHeader("Authorization", RouteUtils.authorize(basicAuth.getUsername(), basicAuth.getPassword()));
        }
        if (StrUtil.isBlank((CharSequence)(uri = (swaggerRoute = this.getRoute(request.getHeader(ROUTE_PROXY_HEADER_NAME))).getUri()))) {
            throw new RuntimeException("Uri is Empty");
        }
        String host = URI.create(uri).getHost();
        String fromUri = request.getRequestURI();
        StringBuilder requestUrlBuilder = new StringBuilder();
        requestUrlBuilder.append(uri);
        if (StrUtil.isNotBlank((CharSequence)this.rootPath) && !StrUtil.equals((CharSequence)this.rootPath, (CharSequence)ROUTE_BASE_PATH)) {
            fromUri = fromUri.replaceFirst(this.rootPath, "");
        }
        if (StrUtil.isNotBlank((CharSequence)swaggerRoute.getServicePath()) && !StrUtil.equals((CharSequence)swaggerRoute.getServicePath(), (CharSequence)ROUTE_BASE_PATH) && StrUtil.startWith((CharSequence)fromUri, (CharSequence)swaggerRoute.getServicePath())) {
            fromUri = fromUri.replaceFirst(swaggerRoute.getServicePath(), "");
        }
        requestUrlBuilder.append(fromUri);
        String requestUrl = requestUrlBuilder.toString();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug("\u76ee\u6807\u8bf7\u6c42Url:{},\u8bf7\u6c42\u7c7b\u578b:{},Host:{}", new Object[]{requestUrl, request.getMethod(), host});
        }
        routeRequestContext.setOriginalUri(fromUri);
        routeRequestContext.setUrl(requestUrl);
        routeRequestContext.setMethod(request.getMethod());
        Enumeration enumeration = request.getHeaderNames();
        while (enumeration.hasMoreElements()) {
            String key = (String)enumeration.nextElement();
            String value = request.getHeader(key);
            if (this.ignoreHeaders.contains(key.toLowerCase())) continue;
            routeRequestContext.addHeader(key, value);
        }
        routeRequestContext.addHeader("Host", host);
        Enumeration params = request.getParameterNames();
        while (params.hasMoreElements()) {
            String name = (String)params.nextElement();
            String value = request.getParameter(name);
            routeRequestContext.addParam(name, value);
        }
        try {
            Collection parts = request.getParts();
            if (CollectionUtil.isNotEmpty((Collection)parts)) {
                parts.forEach(part -> routeRequestContext.addPart((Part)part));
            }
        }
        catch (ServletException e) {
            this.logger.warn("get part error,message:" + e.getMessage());
        }
        routeRequestContext.setRequestContent((InputStream)request.getInputStream());
    }

    public SwaggerRoute getRoute(String header) {
        SwaggerRoute swaggerRoute = this.routeRepository.getRoute(header);
        return swaggerRoute;
    }

    public List<SwaggerRoute> getRoutes() {
        return this.routeRepository.getRoutes();
    }
}

