/*
 * Decompiled with CFR 0.152.
 */
package org.snaker.engine.access.mybatis;

import java.sql.Connection;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.ibatis.transaction.Transaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.snaker.engine.access.transaction.TransactionObjectHolder;
import org.snaker.engine.helper.AssertHelper;

public class MybatisTransaction
implements Transaction {
    private static final Logger log = LoggerFactory.getLogger(MybatisTransaction.class);
    private DataSource dataSource;
    protected Connection connection;
    protected boolean autoCommit;

    public MybatisTransaction(DataSource dataSource) {
        AssertHelper.notNull((Object)dataSource, (String)"No DataSource specified");
        this.dataSource = dataSource;
    }

    public Connection getConnection() throws SQLException {
        this.connection = (Connection)TransactionObjectHolder.get();
        if (this.connection == null) {
            this.connection = this.dataSource.getConnection();
        }
        this.autoCommit = this.connection.getAutoCommit();
        return this.connection;
    }

    public void commit() throws SQLException {
        if (this.connection != null && !this.autoCommit && !this.isConnectionTransactional()) {
            if (log.isDebugEnabled()) {
                log.debug("Committing JDBC Connection [" + this.connection.hashCode() + "]");
            }
            this.connection.commit();
        }
    }

    public void rollback() throws SQLException {
        if (this.connection != null && !this.autoCommit && !this.isConnectionTransactional()) {
            if (log.isDebugEnabled()) {
                log.debug("Rolling back JDBC Connection [" + this.connection.hashCode() + "]");
            }
            this.connection.rollback();
        }
    }

    private boolean isConnectionTransactional() {
        Connection holdCon = (Connection)TransactionObjectHolder.get();
        return holdCon == this.connection || holdCon.equals(this.connection);
    }

    public void close() throws SQLException {
    }
}

