/*
 * Decompiled with CFR 0.152.
 */
package com.jarvis.cache.redis;

import com.jarvis.cache.MSetParam;
import com.jarvis.cache.redis.AbstractRedisCacheManager;
import com.jarvis.cache.redis.IRedis;
import com.jarvis.cache.redis.LettuceRedisUtil;
import com.jarvis.cache.serializer.ISerializer;
import com.jarvis.cache.to.CacheKeyTO;
import com.jarvis.cache.to.CacheWrapper;
import io.lettuce.core.AbstractRedisAsyncCommands;
import io.lettuce.core.cluster.RedisClusterClient;
import io.lettuce.core.cluster.api.StatefulRedisClusterConnection;
import io.lettuce.core.cluster.api.async.RedisAdvancedClusterAsyncCommands;
import io.lettuce.core.codec.ByteArrayCodec;
import io.lettuce.core.codec.RedisCodec;
import java.io.IOException;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LettuceRedisClusterCacheManager
extends AbstractRedisCacheManager {
    private static final Logger log = LoggerFactory.getLogger(LettuceRedisClusterCacheManager.class);
    private final RedisClusterClient redisClusterClient;

    public LettuceRedisClusterCacheManager(RedisClusterClient redisClusterClient, ISerializer<Object> serializer) {
        super(serializer);
        this.redisClusterClient = redisClusterClient;
    }

    protected IRedis getRedis() {
        StatefulRedisClusterConnection connection = this.redisClusterClient.connect((RedisCodec)ByteArrayCodec.INSTANCE);
        return new LettuceRedisClusterClient((StatefulRedisClusterConnection<byte[], byte[]>)connection, this);
    }

    public static class LettuceRedisClusterClient
    implements IRedis {
        private final StatefulRedisClusterConnection<byte[], byte[]> connection;
        private final AbstractRedisCacheManager cacheManager;

        public LettuceRedisClusterClient(StatefulRedisClusterConnection<byte[], byte[]> connection, AbstractRedisCacheManager cacheManager) {
            this.connection = connection;
            this.cacheManager = cacheManager;
        }

        public void close() throws IOException {
            this.connection.close();
        }

        public void set(byte[] key, byte[] value) {
            this.connection.async().set((Object)key, (Object)value);
        }

        public void setex(byte[] key, int seconds, byte[] value) {
            this.connection.async().setex((Object)key, (long)seconds, (Object)value);
        }

        public void hset(byte[] key, byte[] field, byte[] value) {
            this.connection.async().hset((Object)key, (Object)field, (Object)value);
        }

        public void hset(byte[] key, byte[] field, byte[] value, int seconds) {
            this.connection.setAutoFlushCommands(false);
            RedisAdvancedClusterAsyncCommands asyncCommands = this.connection.async();
            asyncCommands.hset((Object)key, (Object)field, (Object)value);
            asyncCommands.expire((Object)key, (long)seconds);
            this.connection.flushCommands();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void mset(Collection<MSetParam> params) {
            this.connection.setAutoFlushCommands(false);
            RedisAdvancedClusterAsyncCommands asyncCommands = this.connection.async();
            try {
                LettuceRedisUtil.executeMSet((AbstractRedisAsyncCommands<byte[], byte[]>)((AbstractRedisAsyncCommands)asyncCommands), this.cacheManager, params);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            finally {
                this.connection.flushCommands();
            }
        }

        public byte[] get(byte[] key) {
            try {
                return (byte[])this.connection.async().get((Object)key).get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public byte[] hget(byte[] key, byte[] field) {
            try {
                return (byte[])this.connection.async().hget((Object)key, (Object)field).get();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return null;
            }
        }

        public Map<CacheKeyTO, CacheWrapper<Object>> mget(Type returnType, Set<CacheKeyTO> keys) {
            RedisAdvancedClusterAsyncCommands asyncCommands = this.connection.async();
            return LettuceRedisUtil.executeMGet(this.connection, (AbstractRedisAsyncCommands<byte[], byte[]>)((AbstractRedisAsyncCommands)asyncCommands), this.cacheManager, returnType, keys);
        }

        public void delete(Set<CacheKeyTO> keys) {
            this.connection.setAutoFlushCommands(false);
            RedisAdvancedClusterAsyncCommands asyncCommands = this.connection.async();
            try {
                for (CacheKeyTO cacheKeyTO : keys) {
                    String hfield;
                    String cacheKey = cacheKeyTO.getCacheKey();
                    if (null == cacheKey || cacheKey.length() == 0) continue;
                    if (log.isDebugEnabled()) {
                        log.debug("delete cache {}", (Object)cacheKey);
                    }
                    if (null == (hfield = cacheKeyTO.getHfield()) || hfield.length() == 0) {
                        asyncCommands.del((Object[])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey)});
                        continue;
                    }
                    asyncCommands.hdel((Object)AbstractRedisCacheManager.KEY_SERIALIZER.serialize(cacheKey), (Object[])new byte[][]{AbstractRedisCacheManager.KEY_SERIALIZER.serialize(hfield)});
                }
            }
            catch (Exception ex) {
                throw new RuntimeException(ex);
            }
            finally {
                this.connection.flushCommands();
            }
        }
    }
}

