/*
 * Decompiled with CFR 0.152.
 */
package weixin.popular.util;

import com.qq.weixin.mp.aes.PKCS7Encoder;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import weixin.popular.api.PayMchAPI;
import weixin.popular.bean.paymch.MchPayApp;
import weixin.popular.bean.paymch.MchPayNativeReply;
import weixin.popular.bean.paymch.PapayEntrustweb;
import weixin.popular.bean.paymch.PapayH5entrustwebResult;
import weixin.popular.bean.paymch.RefundNotifyReqInfo;
import weixin.popular.bean.paymch.WxaEntrustwebData;
import weixin.popular.util.JsonUtil;
import weixin.popular.util.MapUtil;
import weixin.popular.util.SignatureUtil;
import weixin.popular.util.XMLConverUtil;

public abstract class PayUtil {
    private static Logger logger = LoggerFactory.getLogger(PayUtil.class);

    public static String generateMchPayJsRequestJson(String prepay_id, String appId, String key) {
        String package_ = "prepay_id=" + prepay_id;
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("appId", appId);
        map.put("nonceStr", UUID.randomUUID().toString().replace("-", ""));
        map.put("package", package_);
        map.put("signType", "MD5");
        map.put("timeStamp", System.currentTimeMillis() / 1000L + "");
        String paySign = SignatureUtil.generateSign(map, key);
        map.put("paySign", paySign);
        return JsonUtil.toJSONString(map);
    }

    public static String generateMchPayNativeRequestURL(String appid, String mch_id, String productid, String key) {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("appid", appid);
        map.put("mch_id", mch_id);
        map.put("time_stamp", System.currentTimeMillis() / 1000L + "");
        map.put("nonce_str", UUID.randomUUID().toString().replace("-", ""));
        map.put("product_id", productid);
        String sign = SignatureUtil.generateSign(map, key);
        map.put("sign", sign);
        return "weixin://wxpay/bizpayurl?" + MapUtil.mapJoin(map, false, false);
    }

    public static String generateMchPayNativeReplyXML(MchPayNativeReply mchPayNativeReply, String key) {
        Map<String, String> map = MapUtil.objectToMap(mchPayNativeReply, new String[0]);
        String sign = SignatureUtil.generateSign(map, key);
        mchPayNativeReply.setSign(sign);
        return XMLConverUtil.convertToXML(mchPayNativeReply);
    }

    public static MchPayApp generateMchAppData(String prepay_id, String appId, String partnerid, String key) {
        LinkedHashMap<String, String> wx_map = new LinkedHashMap<String, String>();
        wx_map.put("appid", appId);
        wx_map.put("partnerid", partnerid);
        wx_map.put("prepayid", prepay_id);
        wx_map.put("package", "Sign=WXPay");
        wx_map.put("noncestr", UUID.randomUUID().toString().replace("-", ""));
        wx_map.put("timestamp", System.currentTimeMillis() / 1000L + "");
        String sign = SignatureUtil.generateSign(wx_map, key);
        MchPayApp mchPayApp = new MchPayApp();
        mchPayApp.setAppid(appId);
        mchPayApp.setPartnerid(partnerid);
        mchPayApp.setPrepayid(prepay_id);
        mchPayApp.setPackage_((String)wx_map.get("package"));
        mchPayApp.setNoncestr((String)wx_map.get("noncestr"));
        mchPayApp.setTimestamp((String)wx_map.get("timestamp"));
        mchPayApp.setSign(sign);
        return mchPayApp;
    }

    public static String generatePapayEntrustwebURL(PapayEntrustweb papayEntrustweb, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayEntrustweb, new String[0]);
        String sign = SignatureUtil.generateSign(map, key);
        map.put("sign", sign);
        String params = MapUtil.mapJoin(map, false, true);
        return "https://api.mch.weixin.qq.com/papay/entrustweb?" + params;
    }

    public static String generatePapayH5EntrustwebURL(PapayEntrustweb papayEntrustweb, String key) {
        PapayH5entrustwebResult result = PayMchAPI.papayH5entrustweb(papayEntrustweb, key);
        if (result != null && "SUCCESS".equals(result.getResult_code())) {
            return result.getRedirect_url();
        }
        return null;
    }

    public static WxaEntrustwebData generatePapayWxaEntrustweb(PapayEntrustweb papayEntrustweb, String key) {
        Map<String, String> map = MapUtil.objectToMap(papayEntrustweb, new String[0]);
        String sign = SignatureUtil.generateSign(map, "HMAC-SHA256", key);
        papayEntrustweb.setSign(sign);
        WxaEntrustwebData wxaEntrustwebData = new WxaEntrustwebData();
        wxaEntrustwebData.setAppId(papayEntrustweb.getAppid());
        wxaEntrustwebData.setExtraData(papayEntrustweb);
        wxaEntrustwebData.setPath("pages/index/index");
        return wxaEntrustwebData;
    }

    public static RefundNotifyReqInfo decryptRefundNotifyReqInfo(String req_info, String key) {
        try {
            Cipher cipher = Cipher.getInstance("AES/ECB/NoPadding");
            SecretKeySpec sKeySpec = new SecretKeySpec(DigestUtils.md5Hex((String)key).getBytes(), "AES");
            cipher.init(2, sKeySpec);
            byte[] resultByte = cipher.doFinal(Base64.decodeBase64((String)req_info));
            String data = new String(PKCS7Encoder.decode(resultByte));
            return XMLConverUtil.convertToObject(RefundNotifyReqInfo.class, data);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
            return null;
        }
    }
}

