/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg.fast;

import com.github.kilianB.pcg.IncompatibleGeneratorException;
import com.github.kilianB.pcg.sync.PcgRS;

public class PcgRSUFast {
    private static final long MULT_64 = 6364136223846793005L;
    private static long state;
    private static long inc;
    private static boolean gausAvailable;
    private static double nextGaus;
    private static final double DOUBLE_MASK = 9.007199254740992E15;
    private static final float FLOAT_UNIT = 1.6777216E7f;
    private static final long INTEGER_MASK = 0xFFFFFFFFL;

    private PcgRSUFast() {
    }

    public static void seed(long seed, long streamNumber) {
        state = 0L;
        inc = streamNumber << 1 | 1L;
        state = state * 6364136223846793005L + inc;
        state += seed;
    }

    public static void advance(long steps) {
        long acc_mult = 1L;
        long acc_plus = 0L;
        long cur_plus = inc;
        long cur_mult = 6364136223846793005L;
        while (Long.compareUnsigned(steps, 0L) > 0) {
            if ((steps & 1L) == 1L) {
                acc_mult *= cur_mult;
                acc_plus = acc_plus * cur_mult + cur_plus;
            }
            cur_plus *= cur_mult + 1L;
            cur_mult *= cur_mult;
            steps = Long.divideUnsigned(steps, 2L);
        }
        state = acc_mult * state + acc_plus;
    }

    public static byte nextByte() {
        state = state * 6364136223846793005L + inc;
        return (byte)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) >>> 24);
    }

    public static void nextBytes(byte[] b) {
        for (int i = 0; i < b.length; ++i) {
            state = state * 6364136223846793005L + inc;
            b[i] = (byte)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) >>> 24);
        }
    }

    public static char nextChar() {
        state = state * 6364136223846793005L + inc;
        return (char)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) >>> 16);
    }

    public static short nextShort() {
        state = state * 6364136223846793005L + inc;
        return (short)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) >>> 16);
    }

    public static int nextInt() {
        state = state * 6364136223846793005L + inc;
        return (int)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L));
    }

    public static int nextInt(int n) {
        state = state * 6364136223846793005L + inc;
        int r = (int)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L)) >>> 1;
        int m = n - 1;
        if ((n & m) == 0) {
            r = (int)((long)n * (long)r >> 31);
        } else {
            int u = r;
            while (u - (r = u % n) + m < 0) {
                state = state * 6364136223846793005L + inc;
                u = (int)((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L)) >>> 1;
            }
        }
        return r;
    }

    public static boolean nextBoolean() {
        return (((state = state * 6364136223846793005L + inc) >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 != 0L;
    }

    public static boolean nextBoolean(double probability) {
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        state = state * 6364136223846793005L + inc;
        long l = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL;
        return (double)((l >>> 6 << 27) + ((((state = state * 6364136223846793005L + inc) >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15 < probability;
    }

    public static long nextLong() {
        state = state * 6364136223846793005L + inc;
        long l = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L);
        state = state * 6364136223846793005L + inc;
        long j = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L);
        return (l << 32) + (long)((int)j);
    }

    public static long nextLong(long n) {
        long val;
        long j;
        long l;
        long bits;
        do {
            state = state * 6364136223846793005L + inc;
        } while ((bits = ((l = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L)) << 32) + (long)((int)(j = ((state = state * 6364136223846793005L + inc) >>> 22 ^ state) >>> (int)((state >>> 61) + 22L))) >>> 1) - (val = bits % n) + (n - 1L) < 0L);
        return val;
    }

    public static double nextDouble() {
        state = state * 6364136223846793005L + inc;
        long l = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL;
        state = state * 6364136223846793005L + inc;
        return (double)((l >>> 6 << 27) + (((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15;
    }

    public static double nextDouble(boolean includeZero, boolean includeOne) {
        double d = 0.0;
        do {
            state = state * 6364136223846793005L + inc;
            long l = (state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL;
            state = state * 6364136223846793005L + inc;
            d = (double)((l >>> 6 << 27) + (((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 5)) / 9.007199254740992E15;
            if (!includeOne || (((state = state * 6364136223846793005L + inc) >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 == 0L) continue;
            d += 1.0;
        } while (d > 1.0 || !includeZero && d == 0.0);
        return d;
    }

    public static float nextFloat() {
        state = state * 6364136223846793005L + inc;
        return (float)(((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 8) / 1.6777216E7f;
    }

    public static float nextFloat(boolean includeZero, boolean includeOne) {
        float d = 0.0f;
        do {
            state = state * 6364136223846793005L + inc;
            d = (float)(((state >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 8) / 1.6777216E7f;
            if (!includeOne || (((state = state * 6364136223846793005L + inc) >>> 22 ^ state) >>> (int)((state >>> 61) + 22L) & 0xFFFFFFFFL) >>> 31 == 0L) continue;
            d += 1.0f;
        } while (d > 1.0f || !includeZero && d == 0.0f);
        return d;
    }

    public static double nextGaussian() {
        double v2;
        double v1;
        double s;
        if (gausAvailable) {
            gausAvailable = false;
            return nextGaus;
        }
        while ((s = (v1 = 2.0 * PcgRSUFast.nextDouble() - 1.0) * v1 + (v2 = 2.0 * PcgRSUFast.nextDouble() - 1.0) * v2) >= 1.0 || s == 0.0) {
        }
        double multiplier = StrictMath.sqrt(-2.0 * StrictMath.log(s) / s);
        nextGaus = v2 * multiplier;
        gausAvailable = true;
        return v1 * multiplier;
    }

    @Deprecated
    public static void setStreamConstant(long constant) {
        inc = constant;
    }

    public static long distance(PcgRS other) {
        if (inc != other.getInc()) {
            throw new IncompatibleGeneratorException("Can not compare generators with different streams. Those generators will never converge");
        }
        long curState = state;
        long newState = other.getState();
        long curPlus = inc;
        long curMult = 6364136223846793005L;
        long bit = 1L;
        long distance = 0L;
        while (curState != newState) {
            if ((curState & bit) != (newState & bit)) {
                curState = curState * curMult + curPlus;
                distance |= bit;
            }
            bit <<= 1;
            curPlus = (curMult + 1L) * curPlus;
            curMult *= curMult;
        }
        return distance - 1L;
    }

    private static long getRandomSeed(long input) {
        input ^= input >> 12;
        input ^= input << 25;
        input ^= input >> 27;
        return input *= 2685821657736338717L;
    }

    static {
        long seed = PcgRSUFast.getRandomSeed(System.nanoTime());
        long streamNumber = PcgRSUFast.getRandomSeed(System.currentTimeMillis() ^ System.nanoTime());
        PcgRSUFast.seed(seed, streamNumber);
    }
}

