/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.pcg;

import com.github.kilianB.pcg.Pcg;
import java.lang.reflect.InvocationTargetException;
import java.util.Random;

public abstract class RandomBase64
extends Random
implements Pcg {
    private static final long serialVersionUID = -4396858403047759432L;
    protected static final long MULT_64 = 6364136223846793005L;

    public RandomBase64() {
        this(RandomBase64.getRandomSeed(), RandomBase64.getRandomSeed());
    }

    public RandomBase64(long seed, long streamNumber) {
        this.setSeed(seed, streamNumber);
    }

    @Deprecated
    protected RandomBase64(long initialState, long increment, boolean dummy) {
        if (increment == 0L) {
            throw new IllegalArgumentException("The increment can't be 0");
        }
        if (increment % 2L == 0L) {
            throw new IllegalArgumentException("Increment has to be odd");
        }
        this.setState(initialState);
        this.setInc(increment);
    }

    @Override
    public void setSeed(long seed) {
        this.setSeed(seed, seed);
    }

    public void setSeed(long seed, long streamNumber) {
        this.setState(0L);
        this.setInc(streamNumber << 1 | 1L);
        this.stepRight();
        this.setState(this.getState() + seed);
        this.stepRight();
    }

    protected abstract long stepRight();

    @Override
    public <T> T split() throws ReflectiveOperationException {
        try {
            return (T)this.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE, Boolean.TYPE).newInstance(this.getState(), this.getInc(), true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new ReflectiveOperationException("Failed to instantiate clone constructor");
        }
    }

    @Override
    public <T> T splitDistinct() throws ReflectiveOperationException {
        try {
            long curState;
            long curInc;
            while ((curInc = (this.nextLong(Math.abs(this.getInc())) ^ (System.nanoTime() ^ 0xFFFFFFFFFFFFFFFFL)) * 2L + 1L) == this.getInc()) {
            }
            while ((curState = this.nextLong(Math.abs(this.getState())) ^ (System.nanoTime() ^ 0xFFFFFFFFFFFFFFFFL)) == this.getState()) {
            }
            return (T)this.getClass().getDeclaredConstructor(Long.TYPE, Long.TYPE, Boolean.TYPE).newInstance(curState, curInc, true);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            e.getCause().printStackTrace();
            throw new ReflectiveOperationException("Failed to instantiate clone constructor");
        }
    }

    @Override
    public int next(int n) {
        int nInt = this.nextInt();
        int shifted = nInt >>> 32 - n;
        return shifted;
    }

    protected abstract int getInt(long var1);

    @Override
    public boolean nextBoolean(double probability) {
        if (probability < 0.0 || probability > 1.0) {
            throw new IllegalArgumentException("probability must be between 0.0 and 1.0 inclusive.");
        }
        if (probability == 0.0) {
            return false;
        }
        if (probability == 1.0) {
            return true;
        }
        return this.nextDouble() < probability;
    }

    @Override
    public byte nextByte() {
        return (byte)this.next(8);
    }

    @Override
    public void nextBytes(byte[] bytes) {
        for (int x = 0; x < bytes.length; ++x) {
            bytes[x] = (byte)this.next(8);
        }
    }

    @Override
    public char nextChar() {
        return (char)this.next(16);
    }

    @Override
    public short nextShort() {
        return (short)this.next(16);
    }

    @Override
    public int nextInt() {
        return this.getInt(this.stepRight());
    }

    @Override
    public long nextLong() {
        return super.nextLong();
    }

    @Override
    public long nextLong(long n) {
        long val;
        long bits;
        if (n <= 0L) {
            throw new IllegalArgumentException("n must be positive, got: " + n);
        }
        while ((bits = this.nextLong() >>> 1) - (val = bits % n) + (n - 1L) < 0L) {
        }
        return val;
    }

    @Override
    public float nextFloat(boolean includeZero, boolean includeOne) {
        float d = 0.0f;
        do {
            d = this.nextFloat();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0f;
        } while (d > 1.0f || !includeZero && d == 0.0f);
        return d;
    }

    @Override
    public double nextDouble(boolean includeZero, boolean includeOne) {
        double d = 0.0;
        do {
            d = this.nextDouble();
            if (!includeOne || !this.nextBoolean()) continue;
            d += 1.0;
        } while (d > 1.0 || !includeZero && d == 0.0);
        return d;
    }

    protected static long getRandomSeed() {
        long next;
        long current;
        do {
            next = current = UNIQUE_SEED.get();
            next ^= next >> 12;
            next ^= next << 25;
            next ^= next >> 27;
        } while (!UNIQUE_SEED.compareAndSet(current, next *= 2685821657736338717L));
        return next;
    }

    @Override
    public long getMult() {
        return 6364136223846793005L;
    }

    protected abstract void setState(long var1);

    protected abstract void setInc(long var1);
}

