/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.mutable;

import com.github.kilianB.mutable.Mutable;
import java.io.Serializable;

public class MutableFloat
extends Number
implements Mutable<Float>,
Comparable<MutableFloat>,
Serializable {
    private static final long serialVersionUID = 6846548022746719522L;
    private float field;

    public MutableFloat() {
    }

    public MutableFloat(float initialValue) {
        this.field = initialValue;
    }

    @Override
    public int compareTo(MutableFloat o) {
        return Float.compare(this.field, o.field);
    }

    @Override
    public Float getValue() {
        return Float.valueOf(this.field);
    }

    @Override
    public void setValue(Float newValue) {
        this.field = newValue.floatValue();
    }

    @Override
    public void setValue(float newValue) {
        this.field = newValue;
    }

    @Override
    public float floatValue() {
        return this.field;
    }

    public int hashCode() {
        return Float.floatToIntBits(this.field);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MutableFloat other = (MutableFloat)obj;
        return Float.floatToIntBits(this.field) == Float.floatToIntBits(other.field);
    }

    @Override
    public int intValue() {
        return (int)this.field;
    }

    @Override
    public long longValue() {
        return (long)this.field;
    }

    @Override
    public double doubleValue() {
        return this.field;
    }
}

