/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.graphics;

import com.github.kilianB.graphics.FastPixel;
import java.awt.image.BufferedImage;

public class FastPixelSlowDefault
implements FastPixel {
    private static final int FULL = -1;
    private static final int ALPHA_MASK = -16777216;
    private static final int ALPHA_MASK_INVERSE = 0xFFFFFF;
    private static final int RED_MASK = 0xFF0000;
    private static final int RED_MASK_INVERSE = -16711681;
    private static final int GREEN_MASK = 65280;
    private static final int GREEN_MASK_INVERSE = -65281;
    private static final int BLUE_MASK = 255;
    private static final int BLUE_MASK_INVERSE = -256;
    private final boolean alpha;
    private final int width;
    private final int height;
    private final int[] rgbImageData;
    private BufferedImage bImage;

    public FastPixelSlowDefault(BufferedImage bImage) {
        this.alpha = bImage.getColorModel().hasAlpha();
        this.width = bImage.getWidth();
        this.height = bImage.getHeight();
        this.rgbImageData = bImage.getRGB(0, 0, this.width, this.height, null, 0, this.width);
    }

    @Override
    public int getRGB(int index) {
        return this.rgbImageData[index];
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            rgb[x][y] = this.getRGB(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return rgb;
    }

    @Override
    public int getAlpha(int index) {
        if (!this.alpha) {
            return -1;
        }
        return (this.rgbImageData[index] & 0xFF000000) >>> 24;
    }

    @Override
    public int[][] getAlpha() {
        if (!this.alpha) {
            return null;
        }
        int[][] alpha = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            alpha[x][y] = this.getAlpha(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return alpha;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF | newAlpha << 24;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setAlpha(int[][] newAlpha) {
        int x = 0;
        while (x < newAlpha.length) {
            int y = 0;
            while (y < newAlpha[x].length) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF | newAlpha[x][y] << 24;
                ++y;
            }
            ++x;
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getRed(int index) {
        return (this.rgbImageData[index] & 0xFF0000) >>> 16;
    }

    @Override
    public int[][] getRed() {
        int[][] red = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            red[x][y] = this.getRed(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return red;
    }

    @Override
    public void setRed(int index, int newRed) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFF00FFFF | newRed << 16;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setRed(int[][] newRed) {
        int x = 0;
        while (x < newRed.length) {
            int y = 0;
            while (y < newRed[x].length) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFF00FFFF | newRed[x][y] << 16;
                ++y;
            }
            ++x;
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int getGreen(int index) {
        return (this.rgbImageData[index] & 0xFF00) >>> 8;
    }

    @Override
    public void setGreen(int index, int newGreen) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFF00FF | newGreen << 8;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public void setGreen(int[][] newGreen) {
        int x = 0;
        while (x < newGreen.length) {
            int y = 0;
            while (y < newGreen[x].length) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFF00FF | newGreen[x][y] << 8;
                ++y;
            }
            ++x;
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int[][] getGreen() {
        int[][] green = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            green[x][y] = this.getGreen(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return green;
    }

    @Override
    public int getBlue(int index) {
        return this.rgbImageData[index] & 0xFF;
    }

    @Override
    public void setBlue(int index, int newBlue) {
        int newRGB;
        this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF00 | newBlue;
        this.bImage.setRGB(this.getX(index), this.getY(index), newRGB);
    }

    @Override
    public int[][] getBlue() {
        int[][] blue = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            blue[x][y] = this.getBlue(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return blue;
    }

    @Override
    public void setBlue(int[][] newBlue) {
        int x = 0;
        while (x < newBlue.length) {
            int y = 0;
            while (y < newBlue[x].length) {
                int newRGB;
                int index = this.getOffset(x, y);
                this.rgbImageData[index] = newRGB = this.getRGB(index) & 0xFFFFFF00 | newBlue[x][y];
                ++y;
            }
            ++x;
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int[][] getAverageGrayscale() {
        int[][] gray = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            gray[x][y] = this.getAverageGrayscale(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return gray;
    }

    @Override
    public void setAverageGrayscale(int[][] newGrayValue) {
        int x = 0;
        while (x < newGrayValue.length) {
            int y = 0;
            while (y < newGrayValue[x].length) {
                this.setAverageGrayscale(x, y, newGrayValue[x][y]);
                ++y;
            }
            ++x;
        }
        this.bImage.setRGB(0, 0, this.width, this.height, this.rgbImageData, 0, this.width);
    }

    @Override
    public int[][] getLuma() {
        int[][] luma = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.rgbImageData.length) {
            luma[x][y] = this.getLuma(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return luma;
    }

    @Override
    public int[] getLuma1D() {
        int[] luma = new int[this.width * this.height];
        int i = 0;
        while (i < this.rgbImageData.length) {
            luma[i] = this.getLuma(i);
            ++i;
        }
        return luma;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.width + x;
    }

    private int getX(int index) {
        return index % this.width;
    }

    private int getY(int index) {
        return index / this.width;
    }
}

