/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.graphics;

import com.github.kilianB.MathUtil;
import com.github.kilianB.graphics.FastPixel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;

public class FastPixelInt
implements FastPixel {
    private static final int FULL_ALPHA = -16777216;
    private boolean alpha;
    private int width;
    private int height;
    private int[] imageData;
    private int redMask;
    private int greenMask;
    private int blueMask;
    private int alphaMask;
    private int alphaOffset;
    private int redOffset;
    private int blueOffset;
    private int greenOffset;

    public FastPixelInt(BufferedImage bImage) {
        this.imageData = ((DataBufferInt)bImage.getRaster().getDataBuffer()).getData();
        switch (bImage.getType()) {
            case 2: {
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
                this.alphaMask = -16777216;
                this.alpha = true;
                break;
            }
            case 1: {
                this.redMask = 0xFF0000;
                this.greenMask = 65280;
                this.blueMask = 255;
                this.alphaMask = 0;
                break;
            }
            case 4: {
                this.redMask = 255;
                this.greenMask = 65280;
                this.blueMask = 0xFF0000;
                this.alphaMask = 0;
            }
        }
        this.redOffset = MathUtil.getLowerShiftBitMask(this.redMask);
        this.greenOffset = MathUtil.getLowerShiftBitMask(this.greenMask);
        this.blueOffset = MathUtil.getLowerShiftBitMask(this.blueMask);
        this.alphaOffset = MathUtil.getLowerShiftBitMask(this.alphaMask);
        this.width = bImage.getWidth();
        this.height = bImage.getHeight();
    }

    @Override
    public int getRGB(int index) {
        return (this.alpha ? this.getAlpha(index) << 24 : -16777216) | this.getRed(index) << 16 | this.getGreen(index) << 8 | this.getBlue(index);
    }

    @Override
    public int getRGB(int x, int y) {
        return this.getRGB(this.getOffset(x, y));
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            rgb[x][y] = this.getRGB(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return rgb;
    }

    @Override
    public int getAlpha(int index) {
        if (!this.alpha) {
            return -1;
        }
        return (this.imageData[index] & this.alphaMask) >>> this.alphaOffset;
    }

    @Override
    public int getAlpha(int x, int y) {
        return this.getAlpha(this.getOffset(x, y));
    }

    @Override
    public int[][] getAlpha() {
        if (!this.alpha) {
            return null;
        }
        int[][] alpha = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            alpha[x][y] = this.getAlpha(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return alpha;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        if (!this.alpha) {
            return;
        }
        int n = index;
        this.imageData[n] = this.imageData[n] | newAlpha << this.alphaOffset;
    }

    @Override
    public void setAlpha(int x, int y, int newAlpha) {
        this.setAlpha(this.getOffset(x, y), newAlpha);
    }

    @Override
    public void setAlpha(int[][] newAlpha) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setAlpha(x, y, newAlpha[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int getRed(int index) {
        return (this.imageData[index] & this.redMask) >>> this.redOffset;
    }

    @Override
    public int getRed(int x, int y) {
        return this.getRed(this.getOffset(x, y));
    }

    @Override
    public int[][] getRed() {
        int[][] red = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            red[x][y] = this.getRed(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return red;
    }

    @Override
    public void setRed(int index, int newRed) {
        this.imageData[index] = this.imageData[index] & ~this.redMask | newRed << this.redOffset;
    }

    @Override
    public void setRed(int x, int y, int newRed) {
        this.setRed(this.getOffset(x, y), newRed);
    }

    @Override
    public void setRed(int[][] newRed) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setRed(x, y, newRed[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int getGreen(int index) {
        return (this.imageData[index] & this.greenMask) >>> this.greenOffset;
    }

    @Override
    public int getGreen(int x, int y) {
        return this.getGreen(this.getOffset(x, y));
    }

    @Override
    public void setGreen(int index, int newGreen) {
        this.imageData[index] = this.imageData[index] & ~this.greenMask | newGreen << this.greenOffset;
    }

    @Override
    public void setGreen(int x, int y, int newGreen) {
        this.setGreen(this.getOffset(x, y), newGreen);
    }

    @Override
    public void setGreen(int[][] newGreen) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setGreen(x, y, newGreen[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getGreen() {
        int[][] green = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            green[x][y] = this.getGreen(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return green;
    }

    @Override
    public int getBlue(int index) {
        return (this.imageData[index] & this.blueMask) >>> this.blueOffset;
    }

    @Override
    public int getBlue(int x, int y) {
        return this.getBlue(this.getOffset(x, y));
    }

    @Override
    public void setBlue(int index, int newBlue) {
        this.imageData[index] = this.imageData[index] & ~this.blueMask | newBlue << this.blueOffset;
    }

    @Override
    public void setBlue(int x, int y, int newBlue) {
        this.setBlue(this.getOffset(x, y), newBlue);
    }

    @Override
    public int[][] getBlue() {
        int[][] blue = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            blue[x][y] = this.getBlue(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return blue;
    }

    @Override
    public void setBlue(int[][] newBlue) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setBlue(x, y, newBlue[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getAverageGrayscale() {
        int[][] gray = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            gray[x][y] = this.getAverageGrayscale(x, y);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return gray;
    }

    @Override
    public void setAverageGrayscale(int[][] newGrayValue) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setAverageGrayscale(x, y, newGrayValue[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getLuma() {
        int[][] luma = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            luma[x][y] = this.getLuma(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return luma;
    }

    @Override
    public int[] getLuma1D() {
        int[] luma = new int[this.width * this.height];
        int i = 0;
        while (i < this.imageData.length) {
            luma[i] = this.getLuma(i);
            ++i;
        }
        return luma;
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.width + x;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }
}

