/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.graphics;

import com.github.kilianB.graphics.FastPixel;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferByte;

public class FastPixelByte
implements FastPixel {
    private static final int ALPHA_MASK = -16777216;
    private final boolean alpha;
    private final int alphaOffset;
    private final int bytesPerColor;
    private final int width;
    private final int height;
    private final byte[] imageData;

    public FastPixelByte(BufferedImage bImage) {
        this.imageData = ((DataBufferByte)bImage.getRaster().getDataBuffer()).getData();
        if (bImage.getColorModel().hasAlpha()) {
            this.alphaOffset = 1;
            this.alpha = true;
            this.bytesPerColor = 4;
        } else {
            this.alphaOffset = 0;
            this.alpha = false;
            this.bytesPerColor = 3;
        }
        this.width = bImage.getWidth();
        this.height = bImage.getHeight();
    }

    @Override
    public int getRGB(int index) {
        return (this.alpha ? (this.imageData[index++] & 0xFF) << 24 : -16777216) | this.imageData[index++] & 0xFF | (this.imageData[index++] & 0xFF) << 8 | (this.imageData[index++] & 0xFF) << 16;
    }

    @Override
    public int[][] getRGB() {
        int[][] rgb = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            int argb = this.alpha ? (this.imageData[i++] & 0xFF) << 24 : -16777216;
            rgb[x][y] = argb |= this.imageData[i++] & 0xFF | (this.imageData[i++] & 0xFF) << 8 | (this.imageData[i] & 0xFF) << 16;
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            ++i;
        }
        return rgb;
    }

    @Override
    public int[][] getAlpha() {
        if (!this.alpha) {
            return null;
        }
        int[][] alpha = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            alpha[x][y] = this.imageData[i] & 0xFF;
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return alpha;
    }

    @Override
    public int getAlpha(int index) {
        if (!this.alpha) {
            return -1;
        }
        return this.imageData[index] & 0xFF;
    }

    @Override
    public void setAlpha(int index, int newAlpha) {
        if (!this.alpha) {
            return;
        }
        this.imageData[index] = (byte)newAlpha;
    }

    @Override
    public void setAlpha(int[][] newAlpha) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setAlpha(x, y, newAlpha[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int getRed(int index) {
        return this.imageData[index + this.alphaOffset + 2] & 0xFF;
    }

    @Override
    public int[][] getRed() {
        int[][] red = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            red[x][y] = this.getRed(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return red;
    }

    @Override
    public void setRed(int index, int newRed) {
        this.imageData[index + this.alphaOffset + 2] = (byte)newRed;
    }

    @Override
    public void setRed(int[][] newRed) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setRed(x, y, newRed[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int getGreen(int index) {
        return this.imageData[index + this.alphaOffset + 1] & 0xFF;
    }

    @Override
    public void setGreen(int index, int newGreen) {
        this.imageData[index + this.alphaOffset + 1] = (byte)newGreen;
    }

    @Override
    public void setGreen(int[][] newGreen) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setGreen(x, y, newGreen[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getGreen() {
        int[][] green = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            green[x][y] = this.getGreen(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return green;
    }

    @Override
    public int getBlue(int index) {
        return this.imageData[index + this.alphaOffset] & 0xFF;
    }

    @Override
    public void setBlue(int index, int newBlue) {
        this.imageData[index + this.alphaOffset] = (byte)newBlue;
    }

    @Override
    public int[][] getBlue() {
        int[][] blue = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            blue[x][y] = this.getBlue(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return blue;
    }

    @Override
    public void setBlue(int[][] newBlue) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setBlue(x, y, newBlue[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getAverageGrayscale() {
        int[][] gray = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            gray[x][y] = this.getAverageGrayscale(x, y);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return gray;
    }

    @Override
    public void setAverageGrayscale(int[][] newGrayValue) {
        int x = 0;
        while (x < this.width) {
            int y = 0;
            while (y < this.height) {
                this.setAverageGrayscale(x, y, newGrayValue[x][y]);
                ++y;
            }
            ++x;
        }
    }

    @Override
    public int[][] getLuma() {
        int[][] luma = new int[this.width][this.height];
        int x = 0;
        int y = 0;
        int i = 0;
        while (i < this.imageData.length) {
            luma[x][y] = this.getLuma(i);
            if (++x >= this.width) {
                x = 0;
                ++y;
            }
            i += this.bytesPerColor;
        }
        return luma;
    }

    @Override
    public int[] getLuma1D() {
        int[] luma = new int[this.width * this.height];
        int i = 0;
        int j = 0;
        while (i < this.imageData.length) {
            luma[j] = this.getLuma(i);
            i += this.bytesPerColor;
            ++j;
        }
        return luma;
    }

    @Override
    public int getOffset(int x, int y) {
        return y * this.bytesPerColor * this.width + x * this.bytesPerColor;
    }

    @Override
    public boolean hasAlpha() {
        return this.alpha;
    }
}

