/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.graphics;

import com.github.kilianB.MathUtil;
import javafx.scene.paint.Color;

public class ColorUtil {
    public static final double LUMA_RED = 0.299;
    public static final double LUMA_GREEN = 0.587;
    public static final double LUMA_BLUE = 0.114;
    public static final double CR_RED = 0.5;
    public static final double CR_GREEN = 0.418688;
    public static final double CR_BLUE = 0.081312;
    public static final double CB_RED = 0.168736;
    public static final double CB_GREEN = 0.331264;
    public static final double CB_BLUE = 0.5;

    public static java.awt.Color fxToAwtColor(Color fxColor) {
        return new java.awt.Color((float)fxColor.getRed(), (float)fxColor.getGreen(), (float)fxColor.getBlue(), (float)fxColor.getOpacity());
    }

    public static Color awtToFxColor(java.awt.Color awtColor) {
        return new Color((double)awtColor.getRed() / 255.0, (double)awtColor.getGreen() / 255.0, (double)awtColor.getBlue() / 255.0, (double)awtColor.getAlpha() / 255.0);
    }

    public static int[] argbToComponents(int argb) {
        return new int[]{argb >> 24 & 0xFF, argb >> 16 & 0xFF, argb >> 8 & 0xFF, argb & 0xFF};
    }

    public static int componentsToARGB(int alpha, int red, int green, int blue) {
        return alpha << 24 | red << 16 | green << 8 | blue;
    }

    public static Color argbToFXColor(int argb) {
        int[] components = ColorUtil.argbToComponents(argb);
        return new Color((double)components[1] / 255.0, (double)components[2] / 255.0, (double)components[3] / 255.0, (double)components[0] / 255.0);
    }

    public static String fxToHex(Color color) {
        return String.format("#%02X%02X%02X", (int)(color.getRed() * 255.0), (int)(color.getGreen() * 255.0), (int)(color.getBlue() * 255.0));
    }

    public static double distance(Color c1, Color c2) {
        double rmean = (c1.getRed() * 255.0 + c2.getRed() * 255.0) / 2.0;
        int r = (int)(c1.getRed() * 255.0 - c2.getRed() * 255.0);
        int g = (int)(c1.getGreen() * 255.0 - c2.getGreen() * 255.0);
        int b = (int)(c1.getBlue() * 255.0 - c2.getBlue() * 255.0);
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }

    public static double distance(java.awt.Color c1, java.awt.Color c2) {
        double rmean = (c1.getRed() + c2.getRed()) / 2;
        int r = c1.getRed() - c2.getRed();
        int g = c1.getGreen() - c2.getGreen();
        int b = c1.getBlue() - c2.getBlue();
        double weightR = 2.0 + rmean / 256.0;
        double weightG = 4.0;
        double weightB = 2.0 + (255.0 - rmean) / 256.0;
        return Math.sqrt(weightR * (double)r * (double)r + weightG * (double)g * (double)g + weightB * (double)b * (double)b);
    }

    public static double getLuma(Color c) {
        return 0.299 * c.getRed() + 0.587 * c.getGreen() + 0.114 * c.getBlue();
    }

    public static int getLuma(java.awt.Color c) {
        int luma = (int)Math.round(0.299 * (double)c.getRed() + 0.587 * (double)c.getGreen() + 0.114 * (double)c.getBlue());
        return luma > 255 ? 255 : luma;
    }

    public static Color getContrastColor(Color input) {
        double y = ColorUtil.getLuma(input);
        if (y > 0.55) {
            return Color.BLACK;
        }
        return Color.WHITE;
    }

    public static java.awt.Color getContrastColor(java.awt.Color input) {
        int y = ColorUtil.getLuma(input);
        if ((double)y > 140.25) {
            return java.awt.Color.BLACK;
        }
        return java.awt.Color.WHITE;
    }

    public static class ColorPalette {
        public static Color[] getPalette(int numColors) {
            return ColorPalette.getPalette(numColors, Color.web((String)"#003f5c"), Color.web((String)"#ffa600"));
        }

        public static Color[] getPalette(int numColors, Color startColor, Color endColor) {
            Color[] cols = new Color[numColors];
            int i = 0;
            while (i < numColors) {
                double factor = (double)i / (double)numColors;
                cols[i] = startColor.interpolate(endColor, factor);
                ++i;
            }
            return cols;
        }

        public static Color[] getPaletteHue(int numColors) {
            return ColorPalette.getPaletteHue(numColors, Color.web((String)"#003f5c"), Color.web((String)"#ffa600"));
        }

        public static Color[] getPaletteHue(int numColors, Color startColor, Color endColor) {
            double hDelta = (endColor.getHue() - startColor.getHue()) / (double)numColors;
            double sDelta = (endColor.getSaturation() - startColor.getSaturation()) / (double)numColors;
            double bDelta = (endColor.getBrightness() - startColor.getBrightness()) / (double)numColors;
            Color[] cols = new Color[numColors];
            int i = 0;
            while (i < numColors) {
                double newSat = startColor.getSaturation() + sDelta * (double)i;
                double newBrightness = startColor.getBrightness() + bDelta * (double)i;
                if (newSat > 1.0) {
                    newSat = MathUtil.getFractionalPart(newSat);
                } else if (newSat < 0.0) {
                    newSat = 1.0 - newSat;
                }
                if (newBrightness > 1.0) {
                    newBrightness = MathUtil.getFractionalPart(newBrightness);
                } else if (newBrightness < 0.0) {
                    newBrightness = 1.0 - newBrightness;
                }
                cols[i] = Color.hsb((double)(startColor.getHue() + hDelta * (double)i), (double)newSat, (double)newBrightness);
                ++i;
            }
            return cols;
        }
    }
}

