/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.concurrency;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Logger;

public class NamedThreadFactory
implements ThreadFactory {
    private static final Logger LOGGER = Logger.getLogger(NamedThreadFactory.class.getName());
    private static final AtomicInteger poolNumber = new AtomicInteger(1);
    private final ThreadGroup group;
    private final AtomicInteger threadNumber = new AtomicInteger(1);
    private final String namePrefix;
    private final boolean daemon;
    private Thread.UncaughtExceptionHandler handler = (thread, throwable) -> LOGGER.severe("Uncaught exception in: " + thread + "Throwable: " + throwable);

    public NamedThreadFactory() {
        this("");
    }

    public NamedThreadFactory(boolean daemon) {
        this("", daemon);
    }

    public NamedThreadFactory(Thread.UncaughtExceptionHandler handler) {
        this("");
        this.handler = handler;
    }

    public NamedThreadFactory(String namePrefix) {
        this(namePrefix, false);
    }

    public NamedThreadFactory(String namePrefix, boolean daemon) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : Thread.currentThread().getThreadGroup();
        this.namePrefix = namePrefix == null || namePrefix.isEmpty() ? "pool-" + poolNumber.getAndIncrement() + "-thread-" : String.valueOf(namePrefix) + "-";
        this.daemon = daemon;
    }

    public NamedThreadFactory(String namePrefix, Thread.UncaughtExceptionHandler handler) {
        this(namePrefix);
        this.handler = handler;
    }

    public NamedThreadFactory(String namePrefix, boolean daemon, Thread.UncaughtExceptionHandler handler) {
        this(namePrefix, daemon);
        this.handler = handler;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, String.valueOf(this.namePrefix) + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(this.daemon);
        if (t.getPriority() != 5) {
            t.setPriority(5);
        }
        t.setUncaughtExceptionHandler(this.handler);
        return t;
    }
}

