/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.concurrency;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;

public class DelayedConsumerHashMap<T> {
    private final HashMap<Integer, T> objects = new HashMap();
    private final ReentrantLock lock = new ReentrantLock(true);
    private final Condition notEmpty = this.lock.newCondition();
    private Consumer<T> consumer;
    private int sleepDuration;

    public DelayedConsumerHashMap(Consumer<T> consumer, int sleep) {
        this.consumer = consumer;
        this.sleepDuration = sleep;
        Thread internalThread = new Thread(() -> this.handleRequest());
        internalThread.setDaemon(false);
        internalThread.start();
    }

    public void put(Integer key, T object) {
        this.lock.lock();
        this.objects.put(key, object);
        this.notEmpty.signal();
        this.lock.unlock();
    }

    private void handleRequest() {
        block9: {
            try {
                try {
                    this.lock.lock();
                    if (this.objects.size() == 0) {
                        this.notEmpty.await();
                    }
                    for (Map.Entry<Integer, T> entry : this.objects.entrySet()) {
                        this.consumer.accept(entry.getValue());
                    }
                    this.objects.clear();
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                    this.lock.unlock();
                    break block9;
                }
            }
            catch (Throwable throwable) {
                this.lock.unlock();
                throw throwable;
            }
            this.lock.unlock();
        }
        try {
            Thread.sleep(this.sleepDuration);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.handleRequest();
    }
}

