/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.clustering.distance;

import com.github.kilianB.clustering.distance.DistanceFunction;
import java.util.DoubleSummaryStatistics;

public class ManhattanDistance
implements DistanceFunction {
    @Override
    public double distance(double[] v0, double[] v1) {
        double dist = 0.0;
        int i = 0;
        while (i < v0.length) {
            dist += Math.abs(v0[i] - v1[i]);
            ++i;
        }
        return dist;
    }

    @Override
    public double distance(DoubleSummaryStatistics[] v0, double[] v1) {
        double dist = 0.0;
        int i = 0;
        while (i < v0.length) {
            dist += Math.abs(v0[i].getAverage() - v1[i]);
            ++i;
        }
        return dist;
    }

    @Override
    public double distanceSquared(double[] v0, double[] v1) {
        return Math.pow(this.distance(v0, v1), 2.0);
    }

    @Override
    public double distanceSquared(DoubleSummaryStatistics[] v0, double[] v1) {
        return Math.pow(this.distance(v0, v1), 2.0);
    }
}

