/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.clustering;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.clustering.KMeans;
import com.github.kilianB.clustering.distance.DistanceFunction;
import com.github.kilianB.pcg.fast.PcgRSFast;
import java.util.DoubleSummaryStatistics;

public class KMeansPlusPlus
extends KMeans {
    public KMeansPlusPlus(int clusters) {
        super(clusters);
    }

    public KMeansPlusPlus(int clusters, DistanceFunction distanceFunction) {
        super(clusters, distanceFunction);
    }

    @Override
    protected DoubleSummaryStatistics[][] computeStartingClusters(double[][] data, int k, int dataDimension) {
        PcgRSFast rng = new PcgRSFast();
        DoubleSummaryStatistics[][] clusterMeans = new DoubleSummaryStatistics[k][dataDimension];
        ArrayUtil.fillArrayMulti(clusterMeans, () -> new DoubleSummaryStatistics());
        int clusterStart = rng.nextInt(data.length);
        int i = 0;
        while (i < dataDimension) {
            clusterMeans[0][i].accept(data[clusterStart][i]);
            ++i;
        }
        int cluster = 1;
        while (cluster < k) {
            double[] distance = new double[data.length];
            ArrayUtil.fillArray(distance, () -> Double.MAX_VALUE);
            double sum = 0.0;
            int i2 = 0;
            while (i2 < data.length) {
                int j = 0;
                while (j < cluster) {
                    double distTemp = this.distanceFunction.distanceSquared(clusterMeans[j], data[i2]);
                    if (distTemp < distance[i2]) {
                        distance[i2] = distTemp;
                    }
                    ++j;
                }
                sum += distance[i2];
                ++i2;
            }
            int index = 0;
            double rand = rng.nextDouble() * sum;
            double runningSum = distance[0];
            while (index < data.length) {
                if (rand <= runningSum) break;
                runningSum += distance[index];
                ++index;
            }
            int i3 = 0;
            while (i3 < dataDimension) {
                clusterMeans[cluster][i3].accept(data[i3][i3]);
                ++i3;
            }
            ++cluster;
        }
        return clusterMeans;
    }
}

