/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.clustering;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.clustering.ClusterAlgorithm;
import com.github.kilianB.clustering.ClusterResult;
import com.github.kilianB.clustering.distance.DistanceFunction;
import com.github.kilianB.clustering.distance.EuclideanDistance;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;

public class DBScan
implements ClusterAlgorithm {
    private int minPoints;
    private double eps;
    private DistanceFunction dist;

    public DBScan(int minPoints, double eps) {
        this(minPoints, eps, new EuclideanDistance());
    }

    public DBScan(int minPoints, double eps, DistanceFunction dist) {
        this.minPoints = minPoints;
        this.eps = eps;
        this.dist = dist;
    }

    @Override
    public ClusterResult cluster(double[][] data) {
        int clusters = -1;
        int[] cluster = new int[data.length];
        ArrayUtil.fillArray(cluster, () -> -2);
        int i = 0;
        while (i < data.length) {
            if (cluster[i] == -2) {
                ArrayList<Integer> neighboor = new ArrayList<Integer>();
                int j = 0;
                while (j < data.length) {
                    if (i != j && this.dist.distance(data[i], data[j]) <= this.eps) {
                        neighboor.add(j);
                    }
                    ++j;
                }
                if (neighboor.size() < this.minPoints) {
                    cluster[i] = -1;
                } else {
                    cluster[i] = ++clusters;
                    ListIterator<Integer> liter = neighboor.listIterator();
                    while (liter.hasNext()) {
                        int j2 = (Integer)liter.next();
                        if (cluster[j2] == -1) {
                            cluster[j2] = clusters;
                            continue;
                        }
                        if (cluster[j2] != -2) continue;
                        cluster[j2] = clusters;
                        ArrayList<Integer> newNeighboots = new ArrayList<Integer>();
                        int m = 0;
                        while (m < data.length) {
                            if (m != j2 && this.dist.distance(data[m], data[j2]) < this.eps) {
                                newNeighboots.add(m);
                            }
                            ++m;
                        }
                        if (!((double)newNeighboots.size() >= this.eps)) continue;
                        Iterator iterator = newNeighboots.iterator();
                        while (iterator.hasNext()) {
                            int n = (Integer)iterator.next();
                            liter.add(n);
                            liter.previous();
                        }
                    }
                }
            }
            ++i;
        }
        return new ClusterResult(cluster, data);
    }
}

