/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.clustering;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.MathUtil;
import com.github.kilianB.StringUtil;
import com.github.kilianB.clustering.distance.EuclideanDistance;
import com.github.kilianB.graphics.ColorUtil;
import com.github.kilianB.mutable.MutableDouble;
import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.DoubleSummaryStatistics;
import java.util.HashMap;
import java.util.List;
import javafx.scene.paint.Color;
import javax.imageio.ImageIO;

public class ClusterResult {
    protected int numberOfClusters;
    protected int[] clusterIndex;
    protected HashMap<Integer, DoubleSummaryStatistics[]> stats = new HashMap();
    protected HashMap<Integer, List<double[]>> clusters = new HashMap();
    private double sseSum;
    private HashMap<Integer, MutableDouble> sse = new HashMap();
    private HashMap<Integer, MutableDouble> silhouetteCoef = new HashMap();

    public ClusterResult(int[] clusterIndex, double[][] data) {
        int dimensions = data[0].length;
        this.clusterIndex = clusterIndex;
        this.numberOfClusters = ArrayUtil.maximum(clusterIndex) + 1;
        int cluster = -1;
        while (cluster < this.numberOfClusters) {
            this.clusters.put(cluster, new ArrayList());
            DoubleSummaryStatistics[] clusterStats = new DoubleSummaryStatistics[dimensions];
            ArrayUtil.fillArray(clusterStats, () -> new DoubleSummaryStatistics());
            this.stats.put(cluster, clusterStats);
            this.sse.put(cluster, new MutableDouble(0.0));
            this.silhouetteCoef.put(cluster, new MutableDouble(0.0));
            ++cluster;
        }
        int i = 0;
        while (i < data.length) {
            int cluster2 = clusterIndex[i];
            this.clusters.get(cluster2).add(data[i]);
            DoubleSummaryStatistics[] clusterStats = this.stats.get(cluster2);
            int dim = 0;
            while (dim < dimensions) {
                clusterStats[dim].accept(data[i][dim]);
                ++dim;
            }
            ++i;
        }
        EuclideanDistance eucD = new EuclideanDistance();
        int i2 = 0;
        while (i2 < data.length) {
            int cluster3 = clusterIndex[i2];
            if (cluster3 != -1) {
                MutableDouble m = this.sse.get(cluster3);
                double error = 0.0;
                int j = 0;
                while (j < data[i2].length) {
                    error += Math.pow(data[i2][j] - this.stats.get(cluster3)[j].getAverage(), 2.0);
                    ++j;
                }
                m.setValue(m.getValue() + error);
                List<double[]> sameCluster = this.clusters.get(cluster3);
                int pointsInCluster = sameCluster.size() - 1;
                double avgDistSameCluster = 0.0;
                for (double[] p : sameCluster) {
                    avgDistSameCluster += eucD.distance(data[i2], p) / (double)pointsInCluster;
                }
                double minAvgDistanceOtherCluster = Double.MAX_VALUE;
                int j2 = 0;
                while (j2 < this.numberOfClusters) {
                    if (j2 != cluster3) {
                        double avgDistanceOtherCluster = 0.0;
                        List<double[]> otherCluster = this.clusters.get(j2);
                        pointsInCluster = otherCluster.size();
                        for (double[] p : otherCluster) {
                            avgDistanceOtherCluster += eucD.distance(data[i2], p) / (double)pointsInCluster;
                        }
                        if (avgDistanceOtherCluster < minAvgDistanceOtherCluster) {
                            minAvgDistanceOtherCluster = avgDistanceOtherCluster;
                        }
                    }
                    ++j2;
                }
                double silhoutteCoefficient = avgDistSameCluster < minAvgDistanceOtherCluster ? 1.0 - avgDistSameCluster / minAvgDistanceOtherCluster : minAvgDistanceOtherCluster / avgDistSameCluster - 1.0;
                MutableDouble sil = this.silhouetteCoef.get(cluster3);
                sil.setValue(sil.getValue() + silhoutteCoefficient / (double)sameCluster.size());
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.numberOfClusters) {
            this.sseSum += this.sse.get(i2).doubleValue();
            ++i2;
        }
    }

    public void printInformation() {
        StringBuilder sb = new StringBuilder();
        sb.append("Observations: ").append(this.clusterIndex.length).append("\n").append("Number of Clusters: ").append(this.numberOfClusters).append("\n");
        int clusterLength = StringUtil.charsNeeded(this.numberOfClusters);
        int obsLength = StringUtil.charsNeeded(this.clusterIndex.length);
        String format = "%-" + clusterLength + "d (Obs:%" + obsLength + "d) |";
        int hLength = Math.max("Clusters: |".length(), clusterLength + 1 + 5 + obsLength + 2);
        sb.append(String.format("%-" + hLength + "s", "Clusters: ")).append("| Centeroids:\n");
        double silouetteCoeffificient = 0.0;
        DecimalFormat df = new DecimalFormat(".000");
        DecimalFormat sseDf = new DecimalFormat("0.00E0");
        int i = 0;
        while (i < this.numberOfClusters) {
            sb.append(String.format(format, i, this.clusters.get(i).size()));
            DoubleSummaryStatistics[] cStats = this.stats.get(i);
            sb.append(" [ ");
            int j = 0;
            while (j < cStats.length) {
                sb.append(df.format(cStats[j].getAverage())).append(" ");
                ++j;
            }
            silouetteCoeffificient += this.silhouetteCoef.get(i).getValue().doubleValue();
            sb.append("] Silhouette Coef: ").append(df.format(this.silhouetteCoef.get(i).getValue())).append(" SSE:").append(sseDf.format(this.sse.get(i).doubleValue())).append("\n");
            ++i;
        }
        sb.append("SSE: " + df.format(this.sseSum)).append("\n");
        sb.append("Silhouette Coef/#clusters: " + df.format(silouetteCoeffificient / (double)this.numberOfClusters)).append("\n");
        System.out.println(sb.toString());
    }

    public void toImage(File outputFile) {
        BufferedImage bi = new BufferedImage(700, 700, 1);
        Graphics g = bi.getGraphics();
        double minVal = Double.MAX_VALUE;
        double maxVal = -1.7976931348623157E308;
        int cluster = 0;
        while (cluster < this.numberOfClusters) {
            DoubleSummaryStatistics[] clusterStats = this.stats.get(cluster);
            int dim = 0;
            while (dim < clusterStats.length) {
                if (clusterStats[dim].getMax() > maxVal) {
                    maxVal = clusterStats[dim].getMax();
                }
                if (clusterStats[dim].getMin() < minVal) {
                    minVal = clusterStats[dim].getMin();
                }
                ++dim;
            }
            ++cluster;
        }
        Color[] c = ColorUtil.ColorPalette.getPaletteHue(this.numberOfClusters, Color.BLUE, Color.RED);
        g.fillRect(0, 0, 700, 700);
        double newMin = 0.0;
        double newMax = 700.0;
        double observedRange = maxVal - minVal;
        double newRange = newMax - newMin;
        int i = -1;
        while (i < this.numberOfClusters) {
            if (i == -1) {
                g.setColor(ColorUtil.fxToAwtColor(Color.GRAY));
            } else {
                g.setColor(ColorUtil.fxToAwtColor(c[i]));
            }
            List<double[]> points = this.clusters.get(i);
            for (double[] point : points) {
                int x = (int)MathUtil.normalizeValue(point[0], observedRange, maxVal, newRange, newMax, true);
                int y = (int)MathUtil.normalizeValue(point[1], observedRange, maxVal, newRange, newMax, true);
                g.fillOval(x, y, 10, 10);
            }
            ++i;
        }
        g.dispose();
        try {
            ImageIO.write((RenderedImage)bi, "png", outputFile);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public HashMap<Integer, List<double[]>> getClusters() {
        return this.clusters;
    }

    public List<double[]> getCluster(int cluster) {
        return this.clusters.get(cluster);
    }

    public DoubleSummaryStatistics[] getStats(int cluster) {
        return this.stats.get(cluster);
    }

    public int[] getClusterData() {
        return this.clusterIndex;
    }

    public double getSumSquaredError() {
        return this.sseSum;
    }
}

