/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB;

import com.github.kilianB.ArrayUtil;
import java.util.Collection;

public class Require {
    public static <T extends Number> T positiveValue(T value) {
        return Require.positiveValue(value, null);
    }

    public static <T extends Number> T positiveValue(T value, String message) {
        if (value.doubleValue() <= 0.0) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> T inRange(T value, T lowerBound, T higherBound, String message) {
        if (value instanceof Double && ((Double)value).isNaN() || lowerBound instanceof Double && ((Double)lowerBound).isNaN() || higherBound instanceof Double && ((Double)higherBound).isNaN()) {
            throw new IllegalArgumentException("Input may not be NaN");
        }
        if (value.doubleValue() < lowerBound.doubleValue() || value.doubleValue() > higherBound.doubleValue()) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> Collection<T> inRange(Collection<T> value, T lowerBound, T higherBound, String message) {
        for (Number t : value) {
            Require.inRange(t, lowerBound, higherBound, message);
        }
        return value;
    }

    public static <T extends Number> T inRange(T value, T lowerBound, T higherBound) {
        return Require.inRange(value, lowerBound, higherBound, null);
    }

    public static <T> T[] nonNull(T[] array) {
        return Require.nonNull(array, null);
    }

    public static <T> T[] nonNull(T[] array, String message) {
        if (ArrayUtil.allNotNull(array)) {
            return array;
        }
        if (message == null) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(message);
    }

    public static <T> T[] deepNonNull(T[] array) {
        return Require.deepNonNull(array, null);
    }

    public static <T> T[] deepNonNull(T[] array, String message) {
        if (ArrayUtil.deepAllNotNull(array)) {
            return array;
        }
        if (message == null) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(message);
    }

    public static <T> T[] allNull(T[] array) {
        return Require.allNull(array, null);
    }

    public static <T> T[] allNull(T[] array, String message) {
        if (ArrayUtil.allNull(array)) {
            return array;
        }
        if (message == null) {
            throw new IllegalArgumentException();
        }
        throw new IllegalArgumentException(message);
    }

    public static <T> Collection<T> nonNull(Collection<T> list) {
        Require.nonNull(list.toArray(), null);
        return list;
    }

    public static <T> Collection<T> nonNull(Collection<T> list, String message) {
        Require.nonNull(list.toArray(), message);
        return list;
    }

    public static <T extends Number> T oddValue(T value) {
        return Require.oddValue(value, null);
    }

    public static <T extends Number> T oddValue(T value, String message) {
        if (value instanceof Double && ((Double)value).isNaN()) {
            throw new IllegalArgumentException("NaN is neither even or odd");
        }
        if (value.longValue() % 2L == 0L) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> T evenValue(T value) {
        return Require.evenValue(value, null);
    }

    public static <T extends Number> T evenValue(T value, String message) {
        if (value instanceof Double && ((Double)value).isNaN()) {
            throw new IllegalArgumentException("NaN is neither even or odd");
        }
        if (value.longValue() % 2L != 0L) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> T negativeValue(T value) {
        return Require.negativeValue(value, null);
    }

    public static <T extends Number> T negativeValue(T value, String message) {
        if (value.doubleValue() >= 0.0) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> T lessThan(T value, T upperBound) {
        return Require.lessThan(value, upperBound, null);
    }

    public static <T extends Number> T lessThan(T value, T upperBound, String message) {
        if (value.doubleValue() >= upperBound.doubleValue()) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }

    public static <T extends Number> T greaterThan(T value, T lowerBound) {
        return Require.greaterThan(value, lowerBound, null);
    }

    public static <T extends Number> T greaterThan(T value, T lowerBound, String message) {
        if (value.doubleValue() <= lowerBound.doubleValue()) {
            if (message == null) {
                throw new IllegalArgumentException();
            }
            throw new IllegalArgumentException(message);
        }
        return value;
    }
}

