/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB;

import java.io.File;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.Locale;

public class MiscUtil {
    public static void restartApp() {
        Runnable restartApp = new Runnable(){

            @Override
            public void run() {
                String java = String.valueOf(System.getProperty("java.home")) + "/bin/java";
                List<String> vmArguments = ManagementFactory.getRuntimeMXBean().getInputArguments();
                StringBuffer vmArgsOneLine = new StringBuffer();
                for (String arg : vmArguments) {
                    if (arg.contains("-agentlib")) continue;
                    vmArgsOneLine.append(arg);
                    vmArgsOneLine.append(" ");
                }
                StringBuffer cmd = new StringBuffer("\"" + java + "\" " + vmArgsOneLine);
                String[] mainCommand = System.getProperty("sun.java.command").split(" ");
                if (mainCommand[0].endsWith(".jar")) {
                    cmd.append("-jar " + new File(mainCommand[0]).getPath());
                } else {
                    cmd.append("-cp \"" + System.getProperty("java.class.path") + "\" " + mainCommand[0]);
                }
                int i = 1;
                while (i < mainCommand.length) {
                    cmd.append(" ");
                    cmd.append(mainCommand[i]);
                    ++i;
                }
                try {
                    Runtime.getRuntime().exec(cmd.toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        };
        try {
            Class<?> shutdownClass = Class.forName("java.lang.Shutdown");
            Method registerShutdownSlot = shutdownClass.getDeclaredMethod("add", Integer.TYPE, Boolean.TYPE, Runnable.class);
            int i = 3;
            while (i < 10) {
                try {
                    registerShutdownSlot.setAccessible(true);
                    registerShutdownSlot.invoke(null, i, false, restartApp);
                    break;
                }
                catch (IllegalStateException illegalStateException) {
                }
                finally {
                    registerShutdownSlot.setAccessible(false);
                }
                ++i;
            }
        }
        catch (ClassNotFoundException | IllegalAccessException | IllegalArgumentException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            System.out.println("Error registering shutdown hook " + e.getMessage() + e);
        }
        System.exit(0);
    }

    public static int consistentHashCode(Enum e) {
        return e.name().hashCode() * 31 + e.ordinal() ^ e.getClass().getName().hashCode();
    }

    public static enum OS {
        WINDOWS("windows"),
        LINUX("linux"),
        SOLARIS("sunos", "solaris"),
        MAC_OS("darwin", "mac", "macos", "mac os x"),
        UNKNOWN("generic"),
        OTHER("");

        private static OS currentOS;
        private String[] osIdentifier;

        static {
            currentOS = null;
        }

        public static OS getOS() {
            return currentOS == null ? OS.retrieveInfo() : currentOS;
        }

        public String toString() {
            String osPretty = currentOS.name().toLowerCase().replace("_", " ");
            osPretty = String.valueOf(osPretty.substring(0, 1).toUpperCase()) + osPretty.substring(1);
            int index = 0;
            while ((index = osPretty.indexOf(" ", index + 1)) != -1) {
                osPretty = String.valueOf(osPretty.substring(0, 1).toUpperCase()) + osPretty.substring(1);
            }
            return String.valueOf(osPretty) + " " + System.getProperty("os.arch") + " " + System.getProperty("os.version");
        }

        private static OS retrieveInfo() {
            String osName = System.getProperty("os.name").toLowerCase(Locale.ENGLISH);
            OS[] oSArray = OS.values();
            int n = oSArray.length;
            int n2 = 0;
            while (n2 < n) {
                OS os = oSArray[n2];
                String[] stringArray = os.osIdentifier;
                int n3 = os.osIdentifier.length;
                int n4 = 0;
                while (n4 < n3) {
                    String identifier = stringArray[n4];
                    if (osName.contains(identifier)) {
                        currentOS = os;
                        return currentOS;
                    }
                    ++n4;
                }
                ++n2;
            }
            return OTHER;
        }

        private OS(String ... haystack) {
            this.osIdentifier = haystack;
        }
    }
}

