/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB;

import java.lang.reflect.Array;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Function;
import java.util.function.Supplier;

public class ArrayUtil {
    public static String toString(double[] array, int decimalPlaces) {
        return ArrayUtil.toString((Object)array, decimalPlaces);
    }

    public static String toString(float[] array, int decimalPlaces) {
        return ArrayUtil.toString((Object)array, decimalPlaces);
    }

    private static String toString(Object boxedFloats, int decimalPlaces) {
        String format = "%." + decimalPlaces + "f";
        if (boxedFloats == null) {
            return "null";
        }
        int iMax = Array.getLength(boxedFloats) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            b.append(String.format(format, Array.get(boxedFloats, i)));
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static String deepToStringFormatted(Object[] array) {
        String s = Arrays.deepToString(array);
        s = s.replaceAll("],", "]\n");
        return s;
    }

    public static String deepToString(Object[] array) {
        return Arrays.deepToString(array);
    }

    public static String toString(Object[] array) {
        return Arrays.toString(array);
    }

    @Deprecated
    private static String toDeepString(Object boxedFloats, int decimalPlaces) {
        String format = "%." + decimalPlaces + "f";
        if (boxedFloats == null) {
            return "null";
        }
        int iMax = Array.getLength(boxedFloats) - 1;
        if (iMax == -1) {
            return "[]";
        }
        StringBuilder b = new StringBuilder();
        b.append('[');
        int i = 0;
        while (true) {
            Object elem;
            if ((elem = Array.get(boxedFloats, i)).getClass().isArray()) {
                b.append(ArrayUtil.toDeepString(elem, decimalPlaces));
            } else {
                b.append(String.format(format, elem));
            }
            if (i == iMax) {
                return b.append(']').toString();
            }
            b.append(", ");
            ++i;
        }
    }

    public static <T> T[] deepArrayCopy(T[] array) {
        if (array.length <= 0) {
            return array;
        }
        return (Object[])ArrayUtil.deepCopyOf(array, Array.newInstance(array[0].getClass(), array.length), 0);
    }

    @Deprecated
    public static <T> T[] deepArrayCopyClone(T[] array) throws Exception {
        if (array.length <= 0) {
            return array;
        }
        return (Object[])ArrayUtil.deepCloneCopyOf(array, Array.newInstance(array[0].getClass(), array.length), 0);
    }

    private static Object deepCopyOf(Object array, Object copiedArray, int index) {
        if (index >= Array.getLength(array)) {
            return copiedArray;
        }
        Object element = Array.get(array, index);
        if (element != null && element.getClass().isArray()) {
            Array.set(copiedArray, index, ArrayUtil.deepCopyOf(element, Array.newInstance(element.getClass().getComponentType(), Array.getLength(element)), 0));
        } else {
            Array.set(copiedArray, index, element);
        }
        return ArrayUtil.deepCopyOf(array, copiedArray, ++index);
    }

    @Deprecated
    private static Object deepCloneCopyOf(Object array, Object copiedArray, int index) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
        if (index >= Array.getLength(array)) {
            return copiedArray;
        }
        Object element = Array.get(array, index);
        if (element == null) {
            Array.set(copiedArray, index, element);
        } else if (element.getClass().isArray()) {
            Array.set(copiedArray, index, ArrayUtil.deepCopyOf(element, Array.newInstance(element.getClass().getComponentType(), Array.getLength(element)), 0));
        } else if (element instanceof Cloneable) {
            Method clone = element.getClass().getMethod("clone", new Class[0]);
            Object cloned = clone.invoke(element, new Object[0]);
            Array.set(copiedArray, index, cloned);
        } else {
            Array.set(copiedArray, index, element);
        }
        return ArrayUtil.deepCopyOf(array, copiedArray, ++index);
    }

    public static boolean deepAllNotNull(Object[] array) {
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            if (o == null) {
                return false;
            }
            if (o.getClass().isArray() && !ArrayUtil.deepAllNotNull((Object[])o)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <T> boolean allNotNull(T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t == null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static <T> boolean allNull(T[] array) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T t = TArray[n2];
            if (t != null) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static int twoDimtoOneDim(int x, int y, int width) {
        return x * width + y;
    }

    public static <T> void fillArray(T[] array, Supplier<T> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static <T> T fillArrayMulti(T array, Supplier<T> s) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            int i = 0;
            while (i < length) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s));
                ++i;
            }
        } else {
            return s.get();
        }
        return array;
    }

    public static <T> T fillArrayMulti(T array, Function<Integer, T> s) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            int i = 0;
            while (i < length) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s, i));
                ++i;
            }
        }
        return array;
    }

    private static <T> T fillArrayMulti(T array, Function<Integer, T> s, int index) {
        if (array != null && array.getClass().isArray()) {
            int length = Array.getLength(array);
            int i = 0;
            while (i < length) {
                Array.set(array, i, ArrayUtil.fillArrayMulti(Array.get(array, i), s, i));
                ++i;
            }
        } else {
            return s.apply(index);
        }
        return array;
    }

    public static void fillArray(boolean[] array, Supplier<Boolean> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(byte[] array, Supplier<Byte> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(char[] array, Supplier<Character> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get().charValue();
            ++i;
        }
    }

    public static void fillArray(short[] array, Supplier<Short> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(int[] array, Supplier<Integer> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(long[] array, Supplier<Long> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(float[] array, Supplier<Float> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get().floatValue();
            ++i;
        }
    }

    public static void fillArray(double[] array, Supplier<Double> s) {
        int i = 0;
        while (i < array.length) {
            array[i] = s.get();
            ++i;
        }
    }

    public static void fillArray(boolean[] array, Function<Integer, Boolean> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static void fillArray(char[] array, Function<Integer, Character> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i).charValue();
            ++i;
        }
    }

    public static void fillArray(short[] array, Function<Integer, Short> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static void fillArray(int[] array, Function<Integer, Integer> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static void fillArray(long[] array, Function<Integer, Long> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static void fillArray(float[] array, Function<Integer, Float> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i).floatValue();
            ++i;
        }
    }

    public static void fillArray(double[] array, Function<Integer, Double> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static <T> void fillArray(T[] array, Function<Integer, T> supplier) {
        int i = 0;
        while (i < array.length) {
            array[i] = supplier.apply(i);
            ++i;
        }
    }

    public static <T> int linearSearch(T[] array, T needle, int start, int stop) {
        int maxIndex = Math.min(array.length, stop);
        if (start < 0) {
            start = 0;
        }
        int i = start;
        while (i < maxIndex) {
            if (array[i].equals(needle)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static <T> int linearSearch(T[] array, T needle) {
        return ArrayUtil.linearSearch(array, needle, 0, array.length);
    }

    public static <T> int frontBackSearch(T[] array, T needle, int from, int to) {
        --to;
        while (from <= to) {
            if (array[from].equals(needle)) {
                return from;
            }
            if (array[to].equals(needle)) {
                return to;
            }
            ++from;
            --to;
        }
        return -1;
    }

    public static <T> int frontBackSearch(T[] array, T needle) {
        return ArrayUtil.frontBackSearch(array, needle, 0, array.length);
    }

    public static int[] getSortedIndices(boolean[] array, boolean descending) {
        HashMap<Integer, Boolean> sorter = new HashMap<Integer, Boolean>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(byte[] array, boolean descending) {
        HashMap<Integer, Byte> sorter = new HashMap<Integer, Byte>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(char[] array, boolean descending) {
        HashMap<Integer, Character> sorter = new HashMap<Integer, Character>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, Character.valueOf(array[i]));
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(short[] array, boolean descending) {
        HashMap<Integer, Short> sorter = new HashMap<Integer, Short>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(int[] array, boolean descending) {
        HashMap<Integer, Integer> sorter = new HashMap<Integer, Integer>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(long[] array, boolean descending) {
        HashMap<Integer, Long> sorter = new HashMap<Integer, Long>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(float[] array, boolean descending) {
        HashMap<Integer, Float> sorter = new HashMap<Integer, Float>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, Float.valueOf(array[i]));
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int[] getSortedIndices(double[] array, boolean descending) {
        HashMap<Integer, Double> sorter = new HashMap<Integer, Double>();
        int i = 0;
        while (i < array.length) {
            sorter.put(i, array[i]);
            ++i;
        }
        return sorter.entrySet().stream().sorted(descending ? Collections.reverseOrder(Map.Entry.comparingByValue()) : Map.Entry.comparingByValue()).mapToInt(e -> (Integer)e.getKey()).toArray();
    }

    public static int minimumIndex(byte[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        byte min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(char[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        char min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(short[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        short min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(int[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        int min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(long[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        long min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        float min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static int minimumIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int minIndex = 0;
        double min = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] < min) {
                min = array[i];
                minIndex = i;
            }
            ++i;
        }
        return minIndex;
    }

    public static byte minimum(byte[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static char minimum(char[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static short minimum(short[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static int minimum(int[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static long minimum(long[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static float minimum(float[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static double minimum(double[] array) {
        return array[ArrayUtil.minimumIndex(array)];
    }

    public static int maximumIndex(byte[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        byte max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(char[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        char max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(short[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        short max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(int[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        int max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(long[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        long max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(float[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        float max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static int maximumIndex(double[] array) {
        if (array.length == 0) {
            return -1;
        }
        if (array.length == 1) {
            return 0;
        }
        int maxIndex = 0;
        double max = array[0];
        int i = 1;
        while (i < array.length) {
            if (array[i] > max) {
                max = array[i];
                maxIndex = i;
            }
            ++i;
        }
        return maxIndex;
    }

    public static byte maximum(byte[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static char maximum(char[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static short maximum(short[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static int maximum(int[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static long maximum(long[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static float maximum(float[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static double maximum(double[] array) {
        return array[ArrayUtil.maximumIndex(array)];
    }

    public static void add(byte[] arr, byte summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (byte)(arr[n] + summand);
        }
    }

    public static void add(char[] arr, char summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (char)(arr[n] + summand);
        }
    }

    public static void add(short[] arr, short summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (short)(arr[n] + summand);
        }
    }

    public static void add(int[] arr, int summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(long[] arr, long summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(float[] arr, float summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void add(double[] arr, double summand) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] + summand;
        }
    }

    public static void subtract(byte[] arrMinuend, byte subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (byte)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(char[] arrMinuend, char subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (char)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(short[] arrMinuend, short subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = (short)(arrMinuend[n] - subtrahend);
        }
    }

    public static void subtract(int[] arrMinuend, int subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(long[] arrMinuend, long subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(float[] arrMinuend, float subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void subtract(double[] arrMinuend, double subtrahend) {
        int i = 0;
        while (i < arrMinuend.length) {
            int n = i++;
            arrMinuend[n] = arrMinuend[n] - subtrahend;
        }
    }

    public static void multiply(byte[] arr, byte factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (byte)(arr[n] * factor);
        }
    }

    public static void multiply(char[] arr, char factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (char)(arr[n] * factor);
        }
    }

    public static void multiply(short[] arr, short factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = (short)(arr[n] * factor);
        }
    }

    public static void multiply(int[] arr, int factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(long[] arr, long factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(float[] arr, float factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void multiply(double[] arr, double factor) {
        int i = 0;
        while (i < arr.length) {
            int n = i++;
            arr[n] = arr[n] * factor;
        }
    }

    public static void divide(byte[] arrDividend, byte divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (byte)(arrDividend[n] / divisor);
        }
    }

    public static void divide(char[] arrDividend, char divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (char)(arrDividend[n] / divisor);
        }
    }

    public static void divide(short[] arrDividend, short divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = (short)(arrDividend[n] / divisor);
        }
    }

    public static void divide(int[] arrDividend, int divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(long[] arrDividend, long divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(float[] arrDividend, float divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void divide(double[] arrDividend, double divisor) {
        int i = 0;
        while (i < arrDividend.length) {
            int n = i++;
            arrDividend[n] = arrDividend[n] / divisor;
        }
    }

    public static void multiply(byte[] arr, byte[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = (byte)(arr[n] * factors[i]);
            ++i;
        }
    }

    public static void multiply(char[] arr, char[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = (char)(arr[n] * factors[i]);
            ++i;
        }
    }

    public static void multiply(short[] arr, short[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = (short)(arr[n] * factors[i]);
            ++i;
        }
    }

    public static void multiply(int[] arr, int[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = arr[n] * factors[i];
            ++i;
        }
    }

    public static void multiply(long[] arr, long[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = arr[n] * factors[i];
            ++i;
        }
    }

    public static void multiply(float[] arr, float[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = arr[n] * factors[i];
            ++i;
        }
    }

    public static void multiply(double[] arr, double[] factors) {
        int i = 0;
        while (i < arr.length) {
            int n = i;
            arr[n] = arr[n] * factors[i];
            ++i;
        }
    }

    public static void divide(byte[] arrDivisor, byte[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = (byte)(arrDivisor[n] / dividend[i]);
            ++i;
        }
    }

    public static void divide(char[] arrDivisor, char[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = (char)(arrDivisor[n] / dividend[i]);
            ++i;
        }
    }

    public static void divide(short[] arrDivisor, short[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = (short)(arrDivisor[n] / dividend[i]);
            ++i;
        }
    }

    public static void divide(int[] arrDivisor, int[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
            ++i;
        }
    }

    public static void divide(long[] arrDivisor, long[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
            ++i;
        }
    }

    public static void divide(float[] arrDivisor, float[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
            ++i;
        }
    }

    public static void divide(double[] arrDivisor, double[] dividend) {
        int i = 0;
        while (i < arrDivisor.length) {
            int n = i;
            arrDivisor[n] = arrDivisor[n] / dividend[i];
            ++i;
        }
    }

    public static double average(byte[] array) {
        double avg = 0.0;
        double numElem = array.length;
        byte[] byArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            byte b = byArray[n2];
            avg += (double)b / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(char[] array) {
        double avg = 0.0;
        double numElem = array.length;
        char[] cArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            avg += (double)c / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(short[] array) {
        double avg = 0.0;
        double numElem = array.length;
        short[] sArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            short s = sArray[n2];
            avg += (double)s / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(int[] array) {
        double avg = 0.0;
        double numElem = array.length;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int i = nArray[n2];
            avg += (double)i / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(long[] array) {
        double avg = 0.0;
        double numElem = array.length;
        long[] lArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            long l = lArray[n2];
            avg += (double)l / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(float[] array) {
        double avg = 0.0;
        double numElem = array.length;
        float[] fArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            float f = fArray[n2];
            avg += (double)f / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(double[] array) {
        double avg = 0.0;
        double numElem = array.length;
        double[] dArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            double d = dArray[n2];
            avg += d / numElem;
            ++n2;
        }
        return avg;
    }

    public static double average(byte[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(char[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(short[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(int[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(long[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(float[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double average(double[][] array) {
        double avg = 0.0;
        int w = array.length;
        int i = 0;
        while (i < w) {
            avg += ArrayUtil.average(array[i]) / (double)w;
            ++i;
        }
        return avg;
    }

    public static double median(byte[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(char[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(short[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(int[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(long[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(float[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (double)(array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : (double)array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static double median(double[] array) {
        int[] sortedIndices = ArrayUtil.getSortedIndices(array, true);
        int midPoint = sortedIndices.length / 2;
        double medianValue = sortedIndices.length % 2 == 0 ? (array[sortedIndices[midPoint]] + array[sortedIndices[midPoint - 1]]) / 2.0 : array[sortedIndices[midPoint]];
        return medianValue;
    }

    public static <T> T get(Object array, int ... index) {
        Object temp = array;
        int i = 0;
        while (i < index.length) {
            temp = Array.get(temp, index[i]);
            ++i;
        }
        return (T)temp;
    }
}

