/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.persistent;

import com.github.kilianB.datastructures.tree.Result;
import com.github.kilianB.datastructures.tree.binaryTree.BinaryTree;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.TypedImageMatcher;
import com.github.kilianB.matcher.persistent.PersitentBinaryTreeMatcher;
import java.awt.image.BufferedImage;
import java.util.Map;
import java.util.PriorityQueue;

public class ConsecutiveMatcher
extends PersitentBinaryTreeMatcher {
    private static final long serialVersionUID = 831914616034052308L;

    public ConsecutiveMatcher(boolean cacheAddedHashes) {
        super(cacheAddedHashes);
    }

    @Override
    protected PriorityQueue<Result<String>> getMatchingImagesInternal(BufferedImage image, String uniqueId) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        PriorityQueue returnValues = null;
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree binTree = (BinaryTree)this.binTreeMap.get(algo);
            TypedImageMatcher.AlgoSettings settings = (TypedImageMatcher.AlgoSettings)entry.getValue();
            Hash needleHash = this.getHash(algo, uniqueId, image);
            int threshold = 0;
            if (settings.isNormalized()) {
                int hashLength = needleHash.getBitResolution();
                threshold = (int)Math.round(settings.getThreshold() * (double)hashLength);
            } else {
                threshold = (int)settings.getThreshold();
            }
            PriorityQueue temp = binTree.getElementsWithinHammingDistance(needleHash, threshold);
            if (returnValues == null) {
                returnValues = temp;
                continue;
            }
            temp.retainAll(returnValues);
            returnValues = temp;
        }
        return returnValues;
    }
}

