/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.exotic;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.PlainImageMatcher;
import com.github.kilianB.pcg.fast.PcgRSFast;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.imageio.ImageIO;

public class BloomFilter
extends PlainImageMatcher {
    private static final Logger LOGGER = Logger.getLogger(BloomFilter.class.getSimpleName());
    private PcgRSFast rng = new PcgRSFast();
    private boolean[] buckets;
    private int bits = -1;
    private int[] multiplier;
    private int k;
    private int numOfHashesUsed = 0;
    private int n;
    private boolean locked = false;

    public BloomFilter(int expectedElements, int bits) {
        this.bits = bits;
        this.n = expectedElements;
        this.buckets = new boolean[bits];
    }

    public BloomFilter(int expectedElements, double desiredFalsePositiveProbability) {
        this(expectedElements, BloomFilter.getOptimalBitSizeOfFilter(desiredFalsePositiveProbability, expectedElements));
    }

    @Override
    public boolean addHashingAlgorithm(HashingAlgorithm hashingAlgorithm) {
        this.checkLockState();
        boolean added = super.addHashingAlgorithm(hashingAlgorithm);
        return added;
    }

    @Override
    public boolean removeHashingAlgorithm(HashingAlgorithm hashingAlgorithm) {
        this.checkLockState();
        return super.removeHashingAlgorithm(hashingAlgorithm);
    }

    @Override
    public void clearHashingAlgorithms() {
        this.checkLockState();
        super.clearHashingAlgorithms();
    }

    public boolean isPresent(File file) throws IOException {
        return this.isPresent(ImageIO.read(file));
    }

    public boolean isPresent(BufferedImage image) {
        Iterator iter = this.steps.iterator();
        for (int j = 0; j < this.steps.size() && j < this.numOfHashesUsed; ++j) {
            int hashCode = this.imageToHashCode((HashingAlgorithm)iter.next(), image);
            for (int i = 0; i < this.multiplier[j]; ++i) {
                if (this.buckets[this.getBucket(hashCode, i)]) continue;
                return false;
            }
        }
        return true;
    }

    public void addImage(File image) throws IOException {
        this.addImage(ImageIO.read(image));
    }

    public void addImage(BufferedImage image) {
        this.lock();
        Iterator iter = this.steps.iterator();
        for (int j = 0; j < this.steps.size() && j < this.numOfHashesUsed; ++j) {
            int hashCode = this.imageToHashCode((HashingAlgorithm)iter.next(), image);
            for (int i = 0; i < this.multiplier[j]; ++i) {
                this.buckets[this.getBucket((int)hashCode, (int)i)] = true;
            }
        }
    }

    protected int imageToHashCode(HashingAlgorithm hasher, BufferedImage image) {
        Hash hash = hasher.hash(image);
        int hashCode = hash.getHashValue().hashCode();
        hashCode = hashCode * 31 + hasher.algorithmId();
        return hashCode;
    }

    protected int getBucket(int hashCode, int i) {
        this.rng.setSeed((long)hashCode, (long)i);
        return this.rng.nextInt(this.bits);
    }

    protected void checkLockState() {
        if (this.locked) {
            throw new IllegalStateException("The filter can't be modified after images have already been added");
        }
    }

    protected void lock() {
        if (!this.locked) {
            if (this.steps.isEmpty()) {
                throw new IllegalStateException("Can't add image with 0 supplied hashing algorithms");
            }
            int numHashingAlgorithms = this.steps.size();
            this.multiplier = new int[numHashingAlgorithms];
            ArrayUtil.fillArray((int[])this.multiplier, () -> 1);
            this.k = BloomFilter.getOptimalNumberHashFunctions(this.bits, this.n);
            System.out.println("k " + this.k + " " + numHashingAlgorithms);
            if (this.k < numHashingAlgorithms) {
                LOGGER.warning("Fewer hashing algorithms needed as supplied. Discard algos. If desired increase the bit size of the bloom filter.");
                this.numOfHashesUsed = this.k;
            } else {
                this.numOfHashesUsed = numHashingAlgorithms;
                System.out.println("we need more algorithms: " + numHashingAlgorithms + " " + this.k);
                for (int i = 0; i < this.k - numHashingAlgorithms; ++i) {
                    int n = i % this.multiplier.length;
                    this.multiplier[n] = this.multiplier[n] + 1;
                }
            }
            this.locked = true;
        }
    }

    public int bitsSet() {
        int bitsSet = 0;
        for (boolean b : this.buckets) {
            if (!b) continue;
            ++bitsSet;
        }
        return bitsSet;
    }

    public double bucketsSet() {
        return (double)this.bitsSet() / (double)this.buckets.length;
    }

    public double getApproximateDistinctElementsInFilter() {
        return -((double)this.bits / (double)this.k) * Math.log(1.0 - this.bucketsSet());
    }

    public double getFalsePositiveProbability() {
        return this.getFalsePositiveProbability(this.getApproximateDistinctElementsInFilter());
    }

    public double getFalsePositiveProbability(double numberOfElements) {
        return Math.pow(1.0 - Math.exp((double)(-this.k) * numberOfElements / (double)this.bits), this.k);
    }

    public static int getOptimalNumberHashFunctions(int m, int n) {
        int optimalHashFunctions = (int)Math.round((double)m / (double)n * Math.log(2.0));
        return optimalHashFunctions > 0 ? optimalHashFunctions : 1;
    }

    public static int getOptimalBitSizeOfFilter(double p, int n) {
        return -((int)Math.round((double)n * Math.log(p) / (Math.log(2.0) * Math.log(2.0))));
    }
}

