/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.categorize;

import com.github.kilianB.datastructures.ClusterResult;
import com.github.kilianB.datastructures.KMeans;
import com.github.kilianB.datastructures.tree.binaryTreeFuzzy.FuzzyBinaryTree;
import com.github.kilianB.hash.FuzzyHash;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.categorize.CategoricalMatcher;
import com.github.kilianB.matcher.categorize.CategorizationResult;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class WeightedCategoricalMatcher
extends CategoricalMatcher {
    private static final Logger LOGGER = Logger.getLogger(WeightedCategoricalMatcher.class.getSimpleName());
    private DimReduction dimensionalityReduction = DimReduction.NONE;
    protected transient ClusterResult[] clusterResult = null;
    protected transient FuzzyBinaryTree fuzzyBinaryTree = null;

    public WeightedCategoricalMatcher(double newCategoryThreshold, DimReduction reductionTechnique) {
        super(newCategoryThreshold);
        this.dimensionalityReduction = reductionTechnique;
    }

    @Override
    protected void clusterPostcomputation() {
        this.clusterResult = null;
        this.fuzzyBinaryTree = null;
    }

    @Override
    protected void clusterPrecomputation() {
        block3: {
            block2: {
                if (!this.dimensionalityReduction.equals((Object)DimReduction.K_MEANS_APPROXIMATION)) break block2;
                this.clusterResult = new ClusterResult[this.steps.size()];
                int categoryCount = this.getCategories().size();
                int clusterCount = categoryCount / 10;
                KMeans clusterer = new KMeans(clusterCount <= 0 ? 1 : clusterCount);
                int i = 0;
                for (Map.Entry e : this.clusterHash.entrySet()) {
                    this.clusterResult[i++] = clusterer.cluster(((Map)e.getValue()).values().toArray(new Hash[categoryCount]));
                }
                break block3;
            }
            if (!this.dimensionalityReduction.equals((Object)DimReduction.BINARY_TREE)) break block3;
            this.fuzzyBinaryTree = new FuzzyBinaryTree(false);
            for (Map.Entry e : this.clusterHash.entrySet()) {
                this.fuzzyBinaryTree.addHashes(((Map)e.getValue()).values());
            }
        }
    }

    @Override
    protected int getCategory(int iter, String uniqueId, Hash[] hashes, Set<Integer> categoriesAltered) {
        int category = Integer.MIN_VALUE;
        if (iter == 0) {
            if (this.dimensionalityReduction.equals((Object)DimReduction.K_MEANS_APPROXIMATION)) {
                categoriesAltered.clear();
                for (int i = 0; i < this.steps.size(); ++i) {
                    Set<Integer> potentialClusterIds = this.clusterResult[i].getPotentialFits(hashes[i], 1.0).keySet();
                    for (Integer clusters : potentialClusterIds) {
                        categoriesAltered.addAll(this.clusterResult[i].clusterIndexToDataIndex(clusters));
                    }
                }
            } else if (this.dimensionalityReduction.equals((Object)DimReduction.BINARY_TREE)) {
                FuzzyHash binTree = (FuzzyHash)this.fuzzyBinaryTree.getNearestNeighbour((Hash)hashes[0]).get((int)0).value;
                category = (Integer)((Map)this.clusterReverseLookup.get(this.steps.iterator().next())).get(binTree);
            }
        }
        if (iter != 0 || !this.dimensionalityReduction.equals((Object)DimReduction.BINARY_TREE)) {
            CategorizationResult catResult = this.categorizeImage(uniqueId, hashes, categoriesAltered);
            category = catResult.getCategory();
        }
        return category;
    }

    @Override
    protected double computeDistanceForCategory(Hash[] hashes, int category, double bestDistance) {
        int j = 0;
        double hammingDistance = 0.0;
        for (HashingAlgorithm hashAlgorithm : this.steps) {
            FuzzyHash clusterMid = (FuzzyHash)((Map)this.clusterHash.get(hashAlgorithm)).get(category);
            int n = j++;
            Hash imageHash = hashes[n];
            if (!((hammingDistance += clusterMid.weightedDistance(imageHash)) > bestDistance)) continue;
            return Double.MAX_VALUE;
        }
        return hammingDistance;
    }

    @Override
    public boolean addHashingAlgorithm(HashingAlgorithm algo) {
        boolean added = super.addHashingAlgorithm(algo);
        if (this.steps.size() > 1 && this.dimensionalityReduction.equals((Object)DimReduction.BINARY_TREE)) {
            this.dimensionalityReduction = DimReduction.K_MEANS_APPROXIMATION;
            LOGGER.warning("Binary tree approximation not supported for multiple hashes. Fall back to K_Means_approximation");
        }
        return added;
    }

    @Override
    protected double computeDistanceToCluster(FuzzyHash cluster, Hash imageHash) {
        return cluster.weightedDistance(imageHash);
    }

    public static enum DimReduction {
        NONE,
        K_MEANS_APPROXIMATION,
        BINARY_TREE;

    }
}

