/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.categorize;

import com.github.kilianB.Require;
import com.github.kilianB.datastructures.ClusterResult;
import com.github.kilianB.datastructures.KMeansPlusPlus;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.categorize.CategoricalImageMatcher;
import com.github.kilianB.matcher.categorize.CategorizationResult;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class KMeansClassifier
implements CategoricalImageMatcher {
    private KMeansPlusPlus clusterer;
    private LinkedHashMap<String, Hash> addedHashes = new LinkedHashMap();
    private Map<String, Integer> hashesToDataIndex = new HashMap<String, Integer>();
    private ClusterResult res;
    private HashingAlgorithm hasher;

    public KMeansClassifier(int k, HashingAlgorithm hasher) {
        this.clusterer = new KMeansPlusPlus((Integer)Require.positiveValue((Number)k));
        this.hasher = Objects.requireNonNull(hasher);
    }

    @Override
    public void recomputeCategories() {
        Hash[] h = this.addedHashes.values().toArray(new Hash[this.addedHashes.size()]);
        this.res = this.clusterer.cluster(h);
    }

    @Override
    public CategorizationResult categorizeImage(BufferedImage bi) {
        return this.categorizeImage(this.hasher.hash(bi));
    }

    private CategorizationResult categorizeImage(Hash hash) {
        if (this.res == null) {
            return new CategorizationResult(0, Double.NaN);
        }
        int cluster = this.res.getBestFitCluster(hash);
        return new CategorizationResult(cluster, this.res.getCenteroid(cluster).normalizedHammingDistanceFast(hash));
    }

    public void addImage(BufferedImage bi, String uniqueId) {
        Hash hash = this.hasher.hash(bi);
        this.addImage(hash, uniqueId);
    }

    private void addImage(Hash hash, String uniqueId) {
        this.addedHashes.put(uniqueId, hash);
        this.hashesToDataIndex.put(uniqueId, this.addedHashes.size() - 1);
    }

    @Override
    public CategorizationResult categorizeImageAndAdd(BufferedImage bi, String uniqueId) {
        Hash hash = this.hasher.hash(bi);
        this.addImage(hash, uniqueId);
        return this.categorizeImage(hash);
    }

    @Override
    public List<Integer> getCategories() {
        ArrayList<Integer> categories = new ArrayList<Integer>(this.res.getClusters().keySet());
        categories.remove((Object)-1);
        return categories;
    }

    @Override
    public List<String> getImagesInCategory(int category) {
        ArrayList<String> ids = new ArrayList<String>(this.addedHashes.size());
        String[] indices = this.addedHashes.keySet().toArray(new String[this.addedHashes.size()]);
        List<Integer> data = this.res.clusterIndexToDataIndex(category);
        Collections.sort(data);
        for (Integer index : data) {
            ids.add(indices[index]);
        }
        return ids;
    }

    @Override
    public int getCategory(String uniqueId) {
        return this.res.indexToCluster(this.hashesToDataIndex.get(uniqueId));
    }
}

