/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.cached;

import com.github.kilianB.MathUtil;
import com.github.kilianB.datastructures.tree.Result;
import com.github.kilianB.datastructures.tree.binaryTree.BinaryTree;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.TypedImageMatcher;
import com.github.kilianB.matcher.cached.ConsecutiveMatcher;
import java.awt.image.BufferedImage;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.PriorityQueue;

public class CumulativeMatcher
extends ConsecutiveMatcher {
    private TypedImageMatcher.AlgoSettings overallSetting;

    public CumulativeMatcher(double threshold) {
        this(threshold, true);
    }

    public CumulativeMatcher(double threshold, boolean normalized) {
        this(new TypedImageMatcher.AlgoSettings(threshold, normalized));
    }

    public CumulativeMatcher(TypedImageMatcher.AlgoSettings setting) {
        this.overallSetting = Objects.requireNonNull(setting, "Setting may not be null");
    }

    public void addHashingAlgorithm(HashingAlgorithm algo) {
        super.addHashingAlgorithm(algo, 1.0);
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double weight) {
        super.addHashingAlgorithm(algo, weight, false);
    }

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double weight, boolean dummy) {
        super.addHashingAlgorithm(algo, weight, false);
    }

    @Override
    public PriorityQueue<Result<BufferedImage>> getMatchingImages(BufferedImage image) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        double maxDistanceUntilTermination = this.overallSetting.getThreshold();
        HashMap distanceMap = new HashMap();
        boolean first = true;
        float optimalLoadFactor = (float)Math.log(2.0);
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree binTree = (BinaryTree)this.binTreeMap.get(algo);
            int optimalCapacity = (int)(Math.ceil((float)(first ? binTree.getHashCount() : distanceMap.size()) / optimalLoadFactor) + 1.0);
            HashMap temporaryMap = new HashMap(optimalCapacity, optimalLoadFactor);
            Hash needleHash = algo.hash(image);
            int bitRes = algo.getKeyResolution();
            int threshold = 0;
            threshold = this.overallSetting.isNormalized() ? (int)(maxDistanceUntilTermination * (double)bitRes) : (int)maxDistanceUntilTermination;
            PriorityQueue temp = binTree.getElementsWithinHammingDistance(needleHash, threshold);
            double minDistance = Double.MAX_VALUE;
            for (Result res : temp) {
                double normalDistance = ((TypedImageMatcher.AlgoSettings)entry.getValue()).getThreshold() * (res.distance / (double)bitRes);
                if (first) {
                    temporaryMap.put(res, normalDistance);
                    if (!(normalDistance < minDistance)) continue;
                    minDistance = normalDistance;
                    continue;
                }
                if (!distanceMap.containsKey(res)) continue;
                double distanceSoFar = (Double)distanceMap.get(res) + normalDistance;
                double distanceLeft = this.overallSetting.getThreshold() - distanceSoFar;
                if (!(distanceLeft > 0.0)) continue;
                temporaryMap.put(res, distanceSoFar);
                if (!(distanceSoFar < minDistance)) continue;
                minDistance = distanceSoFar;
            }
            distanceMap = temporaryMap;
            if (first) {
                first = false;
            }
            if (!MathUtil.isDoubleEquals((double)(maxDistanceUntilTermination -= minDistance), (double)0.0, (double)-1.0E100)) continue;
            break;
        }
        PriorityQueue<Result<BufferedImage>> returnValues = new PriorityQueue<Result<BufferedImage>>(new Comparator<Result<BufferedImage>>(){

            @Override
            public int compare(Result<BufferedImage> o1, Result<BufferedImage> o2) {
                return Double.compare(o1.normalizedHammingDistance, o2.normalizedHammingDistance);
            }
        });
        for (Map.Entry e : distanceMap.entrySet()) {
            Result matchedImage = (Result)e.getKey();
            matchedImage.normalizedHammingDistance = (Double)e.getValue();
            returnValues.add(matchedImage);
        }
        return returnValues;
    }
}

