/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.matcher.cached;

import com.github.kilianB.datastructures.tree.Result;
import com.github.kilianB.datastructures.tree.binaryTree.BinaryTree;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import com.github.kilianB.matcher.TypedImageMatcher;
import java.awt.image.BufferedImage;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.PriorityQueue;

public class ConsecutiveMatcher
extends TypedImageMatcher {
    protected HashSet<BufferedImage> addedImages = new HashSet();
    protected HashMap<HashingAlgorithm, BinaryTree<BufferedImage>> binTreeMap = new HashMap();

    @Override
    public void addHashingAlgorithm(HashingAlgorithm algo, double threshold, boolean normalized) {
        super.addHashingAlgorithm(algo, threshold, normalized);
        BinaryTree binTree = new BinaryTree(true);
        this.binTreeMap.put(algo, binTree);
        if (!this.addedImages.isEmpty()) {
            this.addedImages.forEach(image -> binTree.addHash(algo.hash((BufferedImage)image), image));
        }
    }

    @Override
    public boolean removeHashingAlgo(HashingAlgorithm algo) {
        this.binTreeMap.remove(algo);
        return super.removeHashingAlgo(algo);
    }

    @Override
    public void clearHashingAlgorithms() {
        this.binTreeMap.clear();
        super.clearHashingAlgorithms();
    }

    @Override
    public Map<HashingAlgorithm, TypedImageMatcher.AlgoSettings> getAlgorithms() {
        return Collections.unmodifiableMap(new LinkedHashMap(this.steps));
    }

    public void addImage(BufferedImage image) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        if (this.addedImages.contains(image)) {
            return;
        }
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree<BufferedImage> binTree = this.binTreeMap.get(algo);
            binTree.addHash(algo.hash(image), image);
        }
        this.addedImages.add(image);
    }

    public void addImages(BufferedImage ... imagesToAdd) {
        for (BufferedImage img : imagesToAdd) {
            this.addImage(img);
        }
    }

    public PriorityQueue<Result<BufferedImage>> getMatchingImages(BufferedImage image) {
        if (this.steps.isEmpty()) {
            throw new IllegalStateException("Please supply at least one hashing algorithm prior to invoking the match method");
        }
        PriorityQueue<Result<BufferedImage>> returnValues = null;
        for (Map.Entry entry : this.steps.entrySet()) {
            HashingAlgorithm algo = (HashingAlgorithm)entry.getKey();
            BinaryTree<BufferedImage> binTree = this.binTreeMap.get(algo);
            TypedImageMatcher.AlgoSettings settings = (TypedImageMatcher.AlgoSettings)entry.getValue();
            Hash needleHash = algo.hash(image);
            int threshold = 0;
            if (settings.isNormalized()) {
                int hashLength = needleHash.getBitResolution();
                threshold = (int)Math.round(settings.getThreshold() * (double)hashLength);
            } else {
                threshold = (int)settings.getThreshold();
            }
            PriorityQueue<Result<BufferedImage>> temp = binTree.getElementsWithinHammingDistance(needleHash, threshold);
            if (returnValues == null) {
                returnValues = temp;
                continue;
            }
            temp.retainAll(returnValues);
            returnValues = temp;
        }
        return returnValues;
    }

    public void printAllTrees() {
        this.binTreeMap.entrySet().forEach(c -> ((BinaryTree)c.getValue()).printTree());
    }
}

