/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms.filter;

import com.github.kilianB.hashAlgorithms.filter.Kernel;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class MultiKernel
extends Kernel {
    private static final long serialVersionUID = -95494777151267950L;
    protected List<Kernel> kernels = new ArrayList<Kernel>();

    public MultiKernel(Kernel ... kernels) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        this.kernels.addAll(Arrays.asList(kernels));
    }

    public MultiKernel(double[][] ... kernelMasks) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        for (double[][] mask : kernelMasks) {
            this.kernels.add(new Kernel(mask));
        }
    }

    public MultiKernel(Kernel.EdgeHandlingStrategy[] edgeHandlingStrategies, double[][] ... kernelMasks) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        if (edgeHandlingStrategies.length != kernelMasks.length) {
            throw new IllegalArgumentException("Not the same number of edge strategies and kernel masks supplied");
        }
        for (int i = 0; i < kernelMasks.length; ++i) {
            this.kernels.add(new Kernel(kernelMasks[i], edgeHandlingStrategies[i]));
        }
    }

    @Override
    public double[][] apply(int[][] input) {
        int width = input.length;
        int height = input[0].length;
        double[][] result = new double[width][height];
        for (int i = 0; i < this.kernels.size(); ++i) {
            result = i == 0 ? this.kernels.get(0).apply(input) : this.kernels.get(i).apply(result);
        }
        return result;
    }

    @Override
    public int[][] applyInt(int[][] input) {
        int width = input.length;
        int height = input[0].length;
        double[][] intermmed = new double[width][height];
        int[][] result = new int[width][height];
        for (int i = 0; i < this.kernels.size(); ++i) {
            if (i == 0) {
                intermmed = this.kernels.get(0).apply(input);
                continue;
            }
            if (i < this.kernels.size() - 1) {
                intermmed = this.kernels.get(i).apply(intermmed);
                continue;
            }
            result = this.kernels.get(i).applyInt(intermmed);
        }
        return result;
    }

    @Override
    public double[][] apply(double[][] input) {
        int width = input.length;
        int height = input[0].length;
        double[][] result = new double[width][height];
        for (int i = 0; i < this.kernels.size(); ++i) {
            result = i == 0 ? this.kernels.get(0).apply(input) : this.kernels.get(i).apply(result);
        }
        return result;
    }

    @Override
    public double[][] apply(byte[][] input) {
        int width = input.length;
        int height = input[0].length;
        double[][] result = new double[width][height];
        for (int i = 0; i < this.kernels.size(); ++i) {
            result = i == 0 ? this.kernels.get(0).apply(input) : this.kernels.get(i).apply(result);
        }
        return result;
    }

    @Override
    public byte[][] applyByte(byte[][] input) {
        int width = input.length;
        int height = input[0].length;
        byte[][] result = new byte[width][height];
        double[][] intermmed = new double[width][height];
        for (int i = 0; i < this.kernels.size(); ++i) {
            if (i == 0) {
                intermmed = this.kernels.get(0).apply(input);
                continue;
            }
            if (i < this.kernels.size() - 1) {
                intermmed = this.kernels.get(i).apply(intermmed);
                continue;
            }
            result = this.kernels.get(i).applyByte(intermmed);
        }
        return result;
    }

    @Override
    public String toString() {
        return "MultiKernel [kernels=" + this.kernels + "]";
    }
}

