/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms.filter;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.hashAlgorithms.filter.Kernel;
import com.github.kilianB.hashAlgorithms.filter.NonAveragingKernel;

public class MaximumKernel
extends NonAveragingKernel {
    private static final long serialVersionUID = 4302400514104308983L;

    public MaximumKernel(int width, int height) {
        super(Kernel.EdgeHandlingStrategy.EXPAND);
        if (width <= 0 || width % 2 == 0 || height <= 0 || height % 2 == 0) {
            throw new IllegalArgumentException("Currently only odd dimensional kernels are supported. Width & height have to be positive");
        }
        double[][] mask = new double[height][width];
        ArrayUtil.fillArrayMulti((Object)mask, () -> Double.valueOf(1.0));
        this.mask = mask;
    }

    public MaximumKernel(double[][] mask) {
        super(mask);
    }

    @Override
    protected double calcValue(byte[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(int[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    @Override
    protected double calcValue(double[][] input, int x, int y) {
        return this.resolveMax(this.computePotentialValues(input, x, y));
    }

    protected double resolveMax(double[][] values) {
        if (values[1].length == 1 && values[1][0] == Double.MIN_VALUE) {
            return values[0][0];
        }
        return values[0][ArrayUtil.maximumIndex((double[])values[1])];
    }
}

