/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms.experimental;

import com.github.kilianB.graphics.FastPixel;
import com.github.kilianB.graphics.ImageUtil;
import com.github.kilianB.hashAlgorithms.HashBuilder;
import com.github.kilianB.hashAlgorithms.experimental.HogHash;
import java.awt.image.BufferedImage;
import java.math.BigInteger;

public class HogHashAngularEncoded
extends HogHash {
    private static final long serialVersionUID = 8174228394380201299L;

    public HogHashAngularEncoded(int bitResolution) {
        super(bitResolution);
    }

    public HogHashAngularEncoded(int width, int height, int cellWidth, int numBins) {
        super(width, height, cellWidth, numBins);
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        int bin;
        int yCell;
        int xCell;
        BufferedImage bi = ImageUtil.getScaledInstance((BufferedImage)image, (int)this.width, (int)this.height);
        FastPixel fp = FastPixel.create((BufferedImage)bi);
        int[][] lum = fp.getLuma();
        int[][][] hog = this.computeHogFeatures(lum);
        double[] binAverage = new double[this.numBins];
        int cells = this.xCells * this.yCells;
        for (xCell = 0; xCell < this.xCells; ++xCell) {
            for (yCell = 0; yCell < this.yCells; ++yCell) {
                for (bin = 0; bin < this.numBins; ++bin) {
                    int n = bin;
                    binAverage[n] = binAverage[n] + (double)(hog[xCell][yCell][bin] / cells);
                }
            }
        }
        for (xCell = 0; xCell < this.xCells; ++xCell) {
            for (yCell = 0; yCell < this.yCells; ++yCell) {
                for (bin = 0; bin < this.numBins; ++bin) {
                    if ((double)hog[xCell][yCell][bin] > binAverage[bin]) {
                        hash.prependZero();
                        continue;
                    }
                    hash.prependOne();
                }
            }
        }
        return hash.toBigInteger();
    }
}

