/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms;

import com.github.kilianB.Require;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashBuilder;
import com.github.kilianB.hashAlgorithms.filter.Filter;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.imageio.ImageIO;

public abstract class HashingAlgorithm
implements Serializable {
    protected List<Filter> preProcessing = new ArrayList<Filter>();
    private static final long serialVersionUID = 3L;
    protected final int bitResolution;
    protected int keyResolution = -1;
    private int algorithmId;
    protected boolean immutableState = false;
    private static final String LOCKED_MODIFICATION_EXCEPTION = "Hashing algorithms may only be modified as long as no hash has been generated or hashcode has been used by this object. This limitation is imposed to ensure that each hash is associated with the correct algorithm id which might change if the internal state of the algorithm is altered. Be aware that method like getKeyResolution() already perform a hashing operation and therefore invalidate further modification requests";

    public HashingAlgorithm(int bitResolution) {
        this.bitResolution = (Integer)Require.positiveValue((Number)bitResolution, (String)"The bit resolution for hashing algorithms has to be positive");
    }

    public Hash[] hash(BufferedImage ... images) {
        Hash[] returnValue = new Hash[images.length];
        for (int i = 0; i < images.length; ++i) {
            returnValue[i] = this.hash(images[i]);
        }
        return returnValue;
    }

    public Hash[] hash(File ... imageFiles) throws IOException {
        Hash[] returnValue = new Hash[imageFiles.length];
        for (int i = 0; i < imageFiles.length; ++i) {
            returnValue[i] = this.hash(imageFiles[i]);
        }
        return returnValue;
    }

    public Hash hash(BufferedImage image) {
        BigInteger hashValue;
        BufferedImage bi = image;
        if (!this.preProcessing.isEmpty()) {
            for (Filter kernel : this.preProcessing) {
                if (bi == null) {
                    bi = kernel.filter(image);
                    continue;
                }
                bi = kernel.filter(bi);
            }
        }
        this.immutableState = true;
        if (this.keyResolution < 0) {
            HashBuilder hb = new HashBuilder(this.bitResolution);
            hashValue = this.hash(bi, hb);
            this.keyResolution = hb.length;
        } else {
            hashValue = this.hash(bi, new HashBuilder(this.getKeyResolution()));
        }
        return new Hash(hashValue, this.getKeyResolution(), this.algorithmId());
    }

    public Hash hash(File imageFile) throws IOException {
        this.immutableState = true;
        return this.hash(ImageIO.read(imageFile));
    }

    protected abstract BigInteger hash(BufferedImage var1, HashBuilder var2);

    public final int algorithmId() {
        if (this.algorithmId == 0) {
            this.algorithmId = 31 * this.precomputeAlgoId();
            this.algorithmId = 31 * this.algorithmId + 5 + this.preProcessing.hashCode();
            this.immutableState = true;
        }
        return this.algorithmId;
    }

    protected abstract int precomputeAlgoId();

    public int getKeyResolution() {
        if (this.keyResolution < 0) {
            BufferedImage bi = new BufferedImage(1, 1, 5);
            HashBuilder sb = new HashBuilder(this.bitResolution);
            this.hash(bi, sb);
            this.keyResolution = sb.length;
        }
        return this.keyResolution;
    }

    public void addFilter(Filter filter) {
        Objects.requireNonNull(filter);
        if (this.immutableState) {
            throw new IllegalStateException(LOCKED_MODIFICATION_EXCEPTION);
        }
        this.preProcessing.add(filter);
    }

    public boolean removeFilter(Filter filter) {
        if (this.immutableState) {
            throw new IllegalStateException(LOCKED_MODIFICATION_EXCEPTION);
        }
        return this.preProcessing.remove(filter);
    }

    public Hash createAlgorithmSpecificHash(Hash original) {
        return original;
    }

    public String toString() {
        return this.getClass().getSimpleName() + " [" + this.bitResolution + "]";
    }

    public int hashCode() {
        return this.algorithmId();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HashingAlgorithm other = (HashingAlgorithm)obj;
        return this.algorithmId() == other.algorithmId();
    }
}

