/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms;

import java.math.BigInteger;

public class HashBuilder {
    private static final byte[] MASK = new byte[]{1, 2, 4, 8, 16, 32, 64, -128};
    private byte[] bytes;
    private int arrayIndex = 0;
    private int bitIndex = 0;
    protected int length;

    public HashBuilder(int bits) {
        this.bytes = new byte[(int)Math.ceil((double)bits / 8.0)];
        this.arrayIndex = this.bytes.length - 1;
    }

    public void prependZero() {
        if (this.bitIndex == 8) {
            this.bitIndex = 0;
            --this.arrayIndex;
            if (this.arrayIndex == -1) {
                byte[] temp = new byte[this.bytes.length + 1];
                System.arraycopy(this.bytes, 0, temp, 1, this.bytes.length);
                this.bytes = temp;
                this.arrayIndex = 0;
            }
        }
        ++this.bitIndex;
        ++this.length;
    }

    public void prependOne() {
        if (this.bitIndex == 8) {
            this.bitIndex = 0;
            --this.arrayIndex;
            if (this.arrayIndex == -1) {
                byte[] temp = new byte[this.bytes.length + 1];
                System.arraycopy(this.bytes, 0, temp, 1, this.bytes.length);
                this.bytes = temp;
                this.arrayIndex = 0;
            }
        }
        int n = this.arrayIndex;
        this.bytes[n] = (byte)(this.bytes[n] | MASK[this.bitIndex++]);
        ++this.length;
    }

    public BigInteger toBigInteger() {
        return new BigInteger(1, this.bytes);
    }
}

