/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms;

import com.github.kilianB.graphics.FastPixel;
import com.github.kilianB.graphics.ImageUtil;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashBuilder;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.math.BigInteger;
import java.util.Objects;
import javafx.scene.paint.Color;

public class DifferenceHash
extends HashingAlgorithm {
    private static final long serialVersionUID = 7236596241664072005L;
    private int height;
    private int width;
    private final Precision precision;

    public DifferenceHash(int bitResolution, Precision precision) {
        super(bitResolution);
        this.computeDimensions(bitResolution);
        this.precision = precision;
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        int y;
        int x;
        FastPixel fp = FastPixel.create((BufferedImage)ImageUtil.getScaledInstance((BufferedImage)image, (int)this.width, (int)this.height));
        int[][] lum = fp.getLuma();
        for (x = 1; x < this.width; ++x) {
            for (y = 0; y < this.height; ++y) {
                if (lum[x][y] >= lum[x - 1][y]) {
                    hash.prependZero();
                    continue;
                }
                hash.prependOne();
            }
        }
        if (!this.precision.equals((Object)Precision.Simple)) {
            for (x = 0; x < this.width; ++x) {
                for (y = 1; y < this.height; ++y) {
                    if (lum[x][y] < lum[x][y - 1]) {
                        hash.prependZero();
                        continue;
                    }
                    hash.prependOne();
                }
            }
        }
        if (this.precision.equals((Object)Precision.Triple)) {
            for (x = 1; x < this.width; ++x) {
                for (y = 1; y < this.height; ++y) {
                    if (lum[x][y] < lum[x - 1][y - 1]) {
                        hash.prependZero();
                        continue;
                    }
                    hash.prependOne();
                }
            }
        }
        return hash.toBigInteger();
    }

    private void computeDimensions(int bitResolution) {
        int dimension = (int)Math.round(Math.sqrt(bitResolution + 1));
        int normalBound = (dimension - 1) * dimension;
        int higherBound = (dimension - 1) * (dimension + 1);
        this.width = dimension;
        this.height = dimension;
        if (higherBound < bitResolution) {
            ++this.width;
            ++this.height;
        } else if (normalBound < bitResolution || normalBound - bitResolution > higherBound - bitResolution) {
            ++this.height;
        }
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash(this.getClass().getName(), this.height, this.width, this.precision.name()) * 31 + 1;
    }

    @Override
    public Hash hash(BufferedImage image) {
        return new DHash(super.hash(image), this.precision, this.width, this.height);
    }

    @Override
    public Hash createAlgorithmSpecificHash(Hash original) {
        return new DHash(original, this.precision, this.width, this.height);
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public static class DHash
    extends Hash {
        private Precision precision;
        private int width;
        private int height;

        public DHash(Hash h, Precision precision, int width, int height) {
            super(h.getHashValue(), h.getBitResolution(), h.getAlgorithmId());
            this.precision = precision;
            this.width = width;
            this.height = height;
        }

        @Override
        public BufferedImage toImage(int blockSize) {
            Color[] colorArr = new Color[]{Color.WHITE, Color.BLACK};
            int[] colorIndex = new int[this.hashLength];
            for (int i = 0; i < this.hashLength; ++i) {
                colorIndex[i] = this.hashValue.testBit(i) ? 1 : 0;
            }
            return this.toImage(colorIndex, colorArr, blockSize);
        }

        @Override
        public BufferedImage toImage(int[] bitColorIndex, Color[] colors, int blockSize) {
            if (this.precision.equals((Object)Precision.Simple)) {
                BufferedImage bi = new BufferedImage(blockSize * this.width, blockSize * this.height, 5);
                FastPixel fp = FastPixel.create((BufferedImage)bi);
                this.drawDoublePrecision(fp, this.width, 1, this.height, 0, blockSize, 0, 0, bitColorIndex, colors);
                return bi;
            }
            if (this.precision.equals((Object)Precision.Double)) {
                BufferedImage bi = new BufferedImage(blockSize * this.width, blockSize * this.height * 2, 5);
                FastPixel fp = FastPixel.create((BufferedImage)bi);
                this.drawDoublePrecision(fp, this.width, 1, this.height, 0, blockSize, 0, 0, bitColorIndex, colors);
                this.drawDoublePrecision(fp, this.width, 0, this.height, 1, blockSize, this.hashLength / 2, this.height, bitColorIndex, colors);
                return bi;
            }
            BufferedImage bi = new BufferedImage(blockSize * this.width, blockSize * this.height * 3, 5);
            FastPixel fp = FastPixel.create((BufferedImage)bi);
            int hashOffset = 0;
            hashOffset += this.drawDoublePrecision(fp, this.width, 1, this.height, 0, blockSize, hashOffset, 0, bitColorIndex, colors);
            hashOffset += this.drawDoublePrecision(fp, this.width, 0, this.height, 1, blockSize, hashOffset, this.height, bitColorIndex, colors);
            this.drawDoublePrecision(fp, this.width, 1, this.height, 1, blockSize, hashOffset, 2 * this.height, bitColorIndex, colors);
            return bi;
        }

        private int drawDoublePrecision(FastPixel writer, int width, int wOffset, int height, int hOffset, int blockSize, int offset, int yOffset, int[] bitColorIndex, Color[] colors) {
            int i = offset;
            for (int w = 0; w < (width - wOffset) * blockSize; w += blockSize) {
                for (int h = 0; h < (height - hOffset) * blockSize; h += blockSize) {
                    Color c = colors[bitColorIndex[i++]];
                    int red = (int)(c.getRed() * 255.0);
                    int green = (int)(c.getGreen() * 255.0);
                    int blue = (int)(c.getBlue() * 255.0);
                    for (int m = 0; m < blockSize; ++m) {
                        for (int n = 0; n < blockSize; ++n) {
                            int x = w + m;
                            int y = h + n + yOffset * blockSize;
                            writer.setRed(x, y, red);
                            writer.setGreen(x, y, green);
                            writer.setBlue(x, y, blue);
                        }
                    }
                }
            }
            return i - offset;
        }
    }

    public static enum Precision {
        Simple,
        Double,
        Triple;

    }
}

