/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hashAlgorithms;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.Require;
import com.github.kilianB.graphics.FastPixel;
import com.github.kilianB.graphics.ImageUtil;
import com.github.kilianB.hashAlgorithms.AverageHash;
import com.github.kilianB.hashAlgorithms.HashBuilder;
import com.github.kilianB.hashAlgorithms.filter.Kernel;
import java.awt.image.BufferedImage;
import java.io.Serializable;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class AverageKernelHash
extends AverageHash
implements Serializable {
    private static final long serialVersionUID = -5234612717498362659L;
    private final List<Kernel> filters;

    public AverageKernelHash(int bitResolution) {
        this(bitResolution, Kernel.boxFilterNormalized(3, 3));
    }

    public AverageKernelHash(int bitResolution, Kernel ... kernels) {
        super(bitResolution);
        this.filters = new ArrayList<Kernel>(Arrays.asList((Kernel[])Require.deepNonNull((Object[])kernels, (String)"The kernel may not be null")));
    }

    @Override
    protected BigInteger hash(BufferedImage image, HashBuilder hash) {
        FastPixel fp = FastPixel.create((BufferedImage)ImageUtil.getScaledInstance((BufferedImage)image, (int)this.width, (int)this.height));
        int[][] luminocity = fp.getLuma();
        double[][] filtered = null;
        for (Kernel kernel : this.filters) {
            if (filtered == null) {
                filtered = kernel.apply(luminocity);
                continue;
            }
            filtered = kernel.apply(filtered);
        }
        double avgPixelValue = ArrayUtil.average(filtered);
        return this.computeHash(hash, filtered, avgPixelValue);
    }

    @Override
    protected int precomputeAlgoId() {
        return Objects.hash(this.getClass().getName(), this.height, this.width, this.filters) * 31;
    }

    @Override
    public String toString() {
        return "AverageKernelHash [height=" + this.height + ", width=" + this.width + ", filters=" + this.filters + "]";
    }
}

