/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.hash;

import com.github.kilianB.graphics.ColorUtil;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.hashAlgorithms.HashingAlgorithm;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.math.BigInteger;
import java.util.logging.Logger;
import javafx.scene.paint.Color;

public class FuzzyHash
extends Hash {
    private static final long serialVersionUID = 1395094691469035167L;
    private static final Logger LOGGER = Logger.getLogger(FuzzyHash.class.getSimpleName());
    protected int[] bits;
    private double[] bitWeights;
    private double[] bitDistance;
    public transient boolean dirtyBits;
    private transient boolean dirtyWeights;
    private transient boolean dirtyDistance;
    private int numHashesAdded;
    private double maxError;

    public FuzzyHash() {
        super(BigInteger.ZERO, 0, Integer.MAX_VALUE);
    }

    public FuzzyHash(Hash ... hashs) {
        super(BigInteger.ZERO, 0, Integer.MAX_VALUE);
        this.merge(hashs);
    }

    private void initHash(int algorithmId, int hashLength) {
        this.algorithmId = algorithmId;
        this.hashLength = hashLength;
        this.bits = new int[hashLength];
        this.bitWeights = new double[hashLength];
        this.bitDistance = new double[hashLength];
    }

    public void merge(Hash hash) {
        if (this.algorithmId == Integer.MAX_VALUE) {
            this.initHash(hash.getAlgorithmId(), hash.getBitResolution());
        }
        if (hash.getBitResolution() != this.getBitResolution() || this.algorithmId != hash.getAlgorithmId()) {
            throw new IllegalArgumentException("Can't merge hashes with unequal length or algorithmIds");
        }
        this.mergeFast(hash);
    }

    public void merge(Hash ... hash) {
        if (hash.length == 0) {
            throw new IllegalArgumentException("Please provide at least 1 hash to add to the matcher");
        }
        for (Hash h : hash) {
            this.merge(h);
        }
    }

    public void mergeFast(Hash hash) {
        if (this.algorithmId == Integer.MAX_VALUE) {
            this.initHash(hash.getAlgorithmId(), hash.getBitResolution());
        }
        for (int i = 0; i < this.getBitResolution(); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] + (hash.getBitUnsafe(i) ? 1 : -1);
            if (this.bits[i] != -1 && this.bits[i] != 1 && this.bits[i] != 0) continue;
            this.dirtyBits = true;
        }
        ++this.numHashesAdded;
        this.dirtyWeights = true;
        this.dirtyDistance = true;
    }

    public void mergeFast(FuzzyHash hash) {
        if (this.algorithmId == Integer.MAX_VALUE) {
            this.initHash(hash.getAlgorithmId(), hash.getBitResolution());
        }
        for (int i = 0; i < this.getBitResolution(); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] + hash.bits[i];
        }
        this.numHashesAdded = hash.getAddedCount() > 0 ? (this.numHashesAdded += hash.getAddedCount()) : ++this.numHashesAdded;
        this.dirtyBits = true;
        this.dirtyWeights = true;
        this.dirtyDistance = true;
    }

    public void mergeFast(Hash ... hash) {
        if (hash.length == 0) {
            throw new IllegalArgumentException("Please provide at least 1 hash to add to the matcher");
        }
        for (Hash h : hash) {
            this.mergeFast(h);
        }
    }

    public void subtract(Hash hash) {
        if (this.algorithmId == Integer.MAX_VALUE) {
            this.initHash(hash.getAlgorithmId(), hash.getBitResolution());
        }
        if (hash.getBitResolution() != this.getBitResolution() || this.algorithmId != hash.getAlgorithmId()) {
            throw new IllegalArgumentException("Can't subtract hashes with unequal length or algorithmIds");
        }
        this.subtractFast(hash);
    }

    public void subtractFast(Hash hash) {
        if (this.algorithmId == Integer.MAX_VALUE) {
            this.initHash(hash.getAlgorithmId(), hash.getBitResolution());
        }
        for (int i = 0; i < this.getBitResolution(); ++i) {
            int n = i;
            this.bits[n] = this.bits[n] - (hash.getBitUnsafe(i) ? 1 : -1);
            if (this.bits[i] != -1 && this.bits[i] != 1 && this.bits[i] != 0) continue;
            this.dirtyBits = true;
        }
        --this.numHashesAdded;
        this.dirtyWeights = true;
        this.dirtyDistance = true;
    }

    public double weightedDistance(Hash h) {
        this.ensureUpToDateDistance();
        double hammingDistance = 0.0;
        for (int bit = this.hashLength - 1; bit >= 0; --bit) {
            if (h.getBitUnsafe(bit)) {
                hammingDistance += this.bitDistance[bit];
                continue;
            }
            hammingDistance += 1.0 - this.bitDistance[bit];
        }
        return hammingDistance / (double)this.hashLength;
    }

    public double weightedDistance(FuzzyHash h) {
        this.ensureUpToDateDistance();
        h.ensureUpToDateDistance();
        try {
            double hammingDistance = 0.0;
            for (int bit = 0; bit < this.bitDistance.length; ++bit) {
                hammingDistance += Math.abs(this.bitDistance[bit] - h.bitDistance[bit]);
            }
            return hammingDistance / (double)this.hashLength;
        }
        catch (NullPointerException np) {
            LOGGER.severe("Null pointer exception in weighted distance calculation. One of the hashes is empty and not initialized");
            throw np;
        }
    }

    public double squaredWeightedDistance(Hash h) {
        this.ensureUpToDateDistance();
        double hammingDistance = 0.0;
        for (int bit = this.hashLength - 1; bit >= 0; --bit) {
            if (h.getBitUnsafe(bit)) {
                hammingDistance += this.bitDistance[bit] * this.bitDistance[bit];
                continue;
            }
            hammingDistance += (1.0 - this.bitDistance[bit]) * (1.0 - this.bitDistance[bit]);
        }
        return hammingDistance / (double)this.hashLength;
    }

    public double squaredWeightedDistance(FuzzyHash h) {
        this.ensureUpToDateDistance();
        h.ensureUpToDateDistance();
        try {
            double hammingDistance = 0.0;
            for (int bit = 0; bit < this.bitDistance.length; ++bit) {
                double temp = Math.abs(this.bitDistance[bit] - h.bitDistance[bit]);
                hammingDistance += temp * temp;
            }
            return hammingDistance / (double)this.hashLength;
        }
        catch (NullPointerException np) {
            LOGGER.severe("Null pointer exception in weighted distance calculation. One of the hashes is empty and not initialized");
            throw np;
        }
    }

    public double getMaximalError() {
        if (this.numHashesAdded == 0) {
            return 0.0;
        }
        this.maxError = 0.0;
        for (int bit = 0; bit < this.bits.length; ++bit) {
            this.maxError += this.getMaxUncertainty(bit);
        }
        return this.maxError / (double)this.bits.length;
    }

    private void computeWeights() {
        if (this.numHashesAdded == 0) {
            this.bitWeights = new double[this.bitWeights.length];
        } else {
            for (int i = 0; i < this.getBitResolution(); ++i) {
                this.bitWeights[i] = (double)this.bits[i] == 0.0 ? 0.0 : (this.bits[i] < 0 ? -((double)(this.numHashesAdded + this.bits[i]) / 2.0 - (double)this.bits[i]) / (double)this.numHashesAdded : ((double)(this.numHashesAdded - this.bits[i]) / 2.0 + (double)this.bits[i]) / (double)this.numHashesAdded);
            }
        }
        this.dirtyWeights = false;
    }

    private void computeDistance() {
        for (int bit = this.hashLength - 1; bit >= 0; --bit) {
            this.bitDistance[bit] = this.bits[bit] > 0 ? (double)(this.numHashesAdded - this.bits[bit]) / 2.0 / (double)this.numHashesAdded : ((double)(this.numHashesAdded + this.bits[bit]) / 2.0 - (double)this.bits[bit]) / (double)this.numHashesAdded;
        }
        this.dirtyDistance = false;
    }

    public void reset() {
        this.updateHash();
        this.numHashesAdded = 1;
        this.bits = new int[this.hashLength];
        for (int i = this.hashLength - 1; i >= 0; --i) {
            this.bits[i] = super.getBitUnsafe(i) ? 1 : -1;
        }
        this.computeWeights();
        this.computeDistance();
    }

    private void updateHash() {
        this.hashValue = BigInteger.ZERO;
        for (int i = this.hashLength - 1; i >= 0; --i) {
            this.hashValue = this.bits[i] > 0 ? this.hashValue.shiftLeft(1).add(BigInteger.ONE) : this.hashValue.shiftLeft(1);
        }
        this.dirtyBits = false;
    }

    public double getCertainty(int position) {
        this.ensureUpToDateWeights();
        return this.bitWeights[position];
    }

    public boolean[] getUncertaintyMask(double certainty) {
        this.ensureUpToDateWeights();
        boolean[] uncertainBits = new boolean[this.getBitResolution()];
        for (int i = 0; i < uncertainBits.length; ++i) {
            uncertainBits[i] = !(this.bitWeights[i] > certainty) && !(this.bitWeights[i] < -certainty);
        }
        return uncertainBits;
    }

    public Hash getUncertaintyHash(double certainty) {
        return this.toUncertaintyHash(this, certainty);
    }

    public Hash toUncertaintyHash(Hash source, double certainty) {
        this.ensureUpToDateWeights();
        int bitCount = this.getBitResolution();
        BigInteger hashValue = BigInteger.ZERO;
        int newBitCount = 0;
        int hashCode = this.algorithmId;
        for (int i = 0; i < bitCount; ++i) {
            if (this.bitWeights[i] > certainty || this.bitWeights[i] < -certainty) continue;
            hashValue = source.getBitUnsafe(i) ? hashValue.shiftLeft(1).add(BigInteger.ONE) : hashValue.shiftLeft(1);
            ++newBitCount;
            hashCode = 31 * hashCode + i;
        }
        return new Hash(hashValue, newBitCount, 31 * hashCode + newBitCount);
    }

    private void ensureUpToDateWeights() {
        if (this.dirtyWeights) {
            this.computeWeights();
        }
    }

    private void ensureUpToDateHash() {
        if (this.dirtyBits) {
            this.updateHash();
        }
    }

    private void ensureUpToDateDistance() {
        if (this.dirtyDistance) {
            this.computeDistance();
        }
    }

    @Override
    public BigInteger getHashValue() {
        this.ensureUpToDateHash();
        return super.getHashValue();
    }

    @Override
    public boolean getBitUnsafe(int position) {
        return this.bits[position] > 0;
    }

    @Override
    public int hammingDistance(Hash h) {
        this.ensureUpToDateHash();
        return super.hammingDistanceFast(h);
    }

    @Override
    public int hammingDistanceFast(Hash h) {
        this.ensureUpToDateHash();
        return super.hammingDistanceFast(h);
    }

    @Override
    public int hammingDistanceFast(BigInteger bInt) {
        this.ensureUpToDateHash();
        return super.hammingDistanceFast(bInt);
    }

    @Override
    public double normalizedHammingDistance(Hash h) {
        this.ensureUpToDateHash();
        return super.normalizedHammingDistanceFast(h);
    }

    @Override
    public double normalizedHammingDistanceFast(Hash h) {
        this.ensureUpToDateHash();
        return super.normalizedHammingDistanceFast(h);
    }

    @Override
    public byte[] toByteArray() {
        this.ensureUpToDateHash();
        return super.toByteArray();
    }

    @Override
    public int hashCode() {
        return System.identityHashCode(this);
    }

    @Override
    public boolean equals(Object obj) {
        return this == obj;
    }

    @Override
    public String toString() {
        this.ensureUpToDateHash();
        return super.toString();
    }

    @Override
    public BufferedImage toImage(int blockSize) {
        this.ensureUpToDateHash();
        Color[] lowerCol = ColorUtil.ColorPalette.getPalette((int)15, (Color)Color.web((String)"#ff642b"), (Color)Color.web((String)"#ffff7c"));
        Color[] higherCol = ColorUtil.ColorPalette.getPalette((int)15, (Color)Color.web((String)"#ffff7c"), (Color)Color.GREEN);
        Color[] colors = new Color[lowerCol.length + higherCol.length];
        System.arraycopy(lowerCol, 0, colors, 0, lowerCol.length);
        System.arraycopy(higherCol, 0, colors, lowerCol.length, higherCol.length);
        int cLength = colors.length;
        int[] colorIndex = new int[this.hashLength];
        for (int i = 0; i < this.hashLength; ++i) {
            colorIndex[i] = (int)(((double)this.bits[i] / (double)this.numHashesAdded + 1.0) / 2.0 * (double)(cLength - 1));
        }
        return this.toImage(colorIndex, colors, blockSize);
    }

    @Override
    public BufferedImage toImage(int blockSize, HashingAlgorithm hashingAlgorithm) {
        this.ensureUpToDateHash();
        Color[] lowerCol = ColorUtil.ColorPalette.getPalette((int)15, (Color)Color.web((String)"#ff642b"), (Color)Color.web((String)"#ffff7c"));
        Color[] higherCol = ColorUtil.ColorPalette.getPalette((int)15, (Color)Color.web((String)"#ffff7c"), (Color)Color.GREEN);
        Color[] colors = new Color[lowerCol.length + higherCol.length];
        System.arraycopy(lowerCol, 0, colors, 0, lowerCol.length);
        System.arraycopy(higherCol, 0, colors, lowerCol.length, higherCol.length);
        int cLength = colors.length;
        int[] colorIndex = new int[this.hashLength];
        for (int i = 0; i < this.hashLength; ++i) {
            colorIndex[i] = (int)(((double)this.bits[i] / (double)this.numHashesAdded + 1.0) / 2.0 * (double)(cLength - 1));
        }
        return hashingAlgorithm.createAlgorithmSpecificHash(this).toImage(colorIndex, colors, blockSize);
    }

    public int getAddedCount() {
        return this.numHashesAdded;
    }

    public double getMaxUncertainty(int bitIndex) {
        return this.getWeightedDistance(bitIndex, this.bits[bitIndex] < 0);
    }

    public double getWeightedDistance(int bitIndex, boolean bit) {
        this.ensureUpToDateDistance();
        if (bit) {
            return this.bitDistance[bitIndex];
        }
        return 1.0 - this.bitDistance[bitIndex];
    }

    @Override
    public void toFile(File saveLocation) throws IOException {
        try (ObjectOutputStream oos = new ObjectOutputStream(new FileOutputStream(saveLocation));){
            oos.writeObject(this);
        }
    }

    public static FuzzyHash fromFile(File source) throws IOException, ClassNotFoundException {
        try (ObjectInputStream ois = new ObjectInputStream(new FileInputStream(source));){
            FuzzyHash fuzzy = (FuzzyHash)ois.readObject();
            fuzzy.dirtyBits = true;
            fuzzy.dirtyDistance = true;
            fuzzy.dirtyWeights = true;
            fuzzy.ensureUpToDateDistance();
            fuzzy.ensureUpToDateHash();
            fuzzy.ensureUpToDateWeights();
            FuzzyHash fuzzyHash = fuzzy;
            return fuzzyHash;
        }
    }
}

