/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.datastructures.tree;

import com.github.kilianB.datastructures.tree.Result;
import com.github.kilianB.datastructures.tree.binaryTree.Leaf;
import com.github.kilianB.datastructures.tree.binaryTree.Node;
import com.github.kilianB.hash.Hash;
import java.io.Serializable;
import java.util.List;
import java.util.PriorityQueue;

public abstract class AbstractBinaryTree<T>
implements Serializable {
    private static final long serialVersionUID = 8698935405804461236L;
    protected Node root;
    protected int hashCount;
    protected boolean ensureHashConsistency;
    protected int algoId;

    public AbstractBinaryTree(boolean ensureHashConsistency) {
        this.root = new Node();
        this.ensureHashConsistency = ensureHashConsistency;
    }

    protected AbstractBinaryTree() {
    }

    protected void addHash(Hash hash, T value) {
        if (this.ensureHashConsistency) {
            if (this.algoId == 0) {
                this.algoId = hash.getAlgorithmId();
            } else if (this.algoId != hash.getAlgorithmId()) {
                throw new IllegalStateException("Tried to add an incompatible hash to the binary tree");
            }
        }
        Node currentNode = this.root;
        for (int i = hash.getBitResolution() - 1; i > 0; --i) {
            boolean bit = hash.getBitUnsafe(i);
            Node tempNode = currentNode.getChild(bit);
            currentNode = tempNode == null ? currentNode.createChild(bit) : tempNode;
        }
        boolean bit = hash.getBit(0);
        Node leafNode = currentNode.getChild(bit);
        Leaf leaf = leafNode != null ? (Leaf)leafNode : (Leaf)currentNode.setChild(bit, new Leaf());
        leaf.addData(value);
        ++this.hashCount;
    }

    public Node getRoot() {
        return this.root;
    }

    public int getHashCount() {
        return this.hashCount;
    }

    public void printTree() {
        this.printTree(this.root, "");
    }

    public abstract PriorityQueue<Result<T>> getElementsWithinHammingDistance(Hash var1, int var2);

    public abstract List<Result<T>> getNearestNeighbour(Hash var1);

    private void printTree(Node n, String curString) {
        if (n instanceof Leaf) {
            System.out.println("Leaf found: " + curString + " " + ((Leaf)n).getData());
        } else {
            if (n.leftChild != null) {
                this.printTree(n.leftChild, curString + "1");
            }
            if (n.rightChild != null) {
                this.printTree(n.rightChild, curString + "0");
            }
        }
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.algoId;
        result = 31 * result + (this.ensureHashConsistency ? 1231 : 1237);
        result = 31 * result + this.hashCount;
        result = 31 * result + (this.root == null ? 0 : this.root.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof AbstractBinaryTree)) {
            return false;
        }
        AbstractBinaryTree other = (AbstractBinaryTree)obj;
        if (this.algoId != other.algoId) {
            return false;
        }
        if (this.ensureHashConsistency != other.ensureHashConsistency) {
            return false;
        }
        if (this.hashCount != other.hashCount) {
            return false;
        }
        return !(this.root == null ? other.root != null : !this.root.equals(other.root));
    }
}

