/*
 * Decompiled with CFR 0.152.
 */
package com.github.kilianB.datastructures;

import com.github.kilianB.ArrayUtil;
import com.github.kilianB.datastructures.KMeans;
import com.github.kilianB.hash.FuzzyHash;
import com.github.kilianB.hash.Hash;
import com.github.kilianB.pcg.fast.PcgRSFast;

public class KMeansPlusPlus
extends KMeans {
    public KMeansPlusPlus(int clusters) {
        super(clusters);
    }

    @Override
    protected FuzzyHash[] computeStartingClusters(Hash[] hashes) {
        PcgRSFast rng = new PcgRSFast();
        FuzzyHash[] clusterMeans = new FuzzyHash[this.k];
        ArrayUtil.fillArrayMulti((Object)clusterMeans, () -> new FuzzyHash());
        clusterMeans[0].mergeFast(hashes[rng.nextInt(hashes.length)]);
        for (int cluster = 1; cluster < this.k; ++cluster) {
            double[] distance = new double[hashes.length];
            ArrayUtil.fillArray((double[])distance, () -> Double.MAX_VALUE);
            double sum = 0.0;
            for (int i = 0; i < hashes.length; ++i) {
                for (int j = 0; j < cluster; ++j) {
                    double distTemp = clusterMeans[j].normalizedHammingDistanceFast(hashes[i]);
                    if (!((distTemp *= distTemp) < distance[i])) continue;
                    distance[i] = distTemp;
                }
                sum += distance[i];
            }
            int index = 0;
            double rand = rng.nextDouble() * sum;
            for (double runningSum = distance[0]; index < hashes.length && !(rand <= runningSum); runningSum += distance[index + 1], ++index) {
            }
            clusterMeans[cluster].mergeFast(hashes[index]);
        }
        return clusterMeans;
    }
}

